(function (Ext) {
  Ext.define('Suncode.pzmodule.feature.table.PanelFiltersFeature', {
    extend: 'Ext.grid.feature.Feature',
    alias: 'feature.panelfilters',
    uses: ['Suncode.pzmodule.view.filter.PanelFilter',
      'Suncode.pzmodule.view.filter.StringPanelFilter',
      'Suncode.pzmodule.view.filter.IntegerPanelFilter',
      'Suncode.pzmodule.view.filter.FloatPanelFilter',
      'Suncode.pzmodule.view.filter.DatePanelFilter'],
    init: function (grid) {
      this.initFilterTask();
      this.supplyFilters();
      this.bindStore(grid.getStore());

      grid.on({
        scope: this,
        beforedestroy: this.destroy
      });
    },
    initFilterTask: function () {
      this.filterTask = Ext.create('Ext.util.DelayedTask', this.filterRecords,
          this);
    },
    supplyFilters: function () {
      Ext.each(this.filters, function (filter, index, filters) {
        Ext.apply(filter, {
          filterTask: this.filterTask,
          liveFiltering: this.liveFiltering
        });
      }, this);
    },
    bindStore: function (store) {
      store.addListener('beforeload', this.onBeforeLoad, this);
    },
    onBeforeLoad: function (store, options) {
      options.params = options.params || {};
      var values = this.getFilterValues();

      Ext.apply(options.params, {
        filter: Ext.JSON.encode(values)
      });
    },
    getFilterValues: function () {
      var values = new Array();

      Ext.each(this.filters, function (filter, index, filters) {
        var value = filter.getFilterValue();

        if (!Ext.isEmpty(value)) {
          values = values.concat(value);
        }
      }, this);

      return values;
    },
    destroy: function () {
      this.clearListeners();
    },
    filterRecords: function () {
      this.cancelFilterTask();
      var table = this.getTable();
      table.reloadRecords();
    },
    cancelFilterTask: function () {
      this.filterTask.cancel();
    },
    getTable: function () {
      return this.grid;
    },
    clearFilters: function () {
      Ext.each(this.filters, function (filter, index, filters) {
        filter.clearFilter();
      });
    }
  });
}(this.Ext4));