( function( Ext ) {
  var messages = Suncode.context( 'pzmodule' ).messages;

  Ext.define( 'Suncode.pzmodule.controller.table.RecordTableController', {
    extend: 'Ext.app.Controller',
    init: function() {
      this.control( {
        'recordtable': {
          afterrender: this.onAfterRender,
          selectionchange: this.onSelectionChange,
          deselect: this.onDeselect,
          select: this.onSelect,
          beforestatesave: this.onBeforeStateSave,
          groupcontextmenu: this.onGroupContextMenu,
          sortchange: this.onSortChange,
          columnhide: this.onColumnVisibilityToggle,
          columnshow: this.onColumnVisibilityToggle
        }
      } );
    },
    onAfterRender: function( table, eOpts ) {
      var store = table.getStore();
      var proxy = store.getProxy();
      var view = table.getView();
      store.addListener( 'load', this.onLoadRecords, table );
      store.addListener( 'groupchange', this.onGroupChange, table );
      store.addListener( 'beforesync', this.onBeforeSync, table );
      store.addListener( 'update', this.onRecordUpdate, table );
      proxy.addListener( 'exception', this.onLoadException, table );
      view.addListener( 'groupcollapse', this.onGroupCollapse, table );
      view.addListener( 'groupexpand', this.onGroupExpand, table );
    },
    onLoadRecords: function ( store, records, successful, eOpts ) {
      if ( successful ) {
        if ( this.shouldRefreshPanelFilters() ) {
          this.refreshPanelFilters();
        }

        if ( this.shouldMarkFilteredGroup() ) {
          this.markFilteredGroup();
        }

        if ( this.isAttached() ) {
          this.setInitiallyAttachedRecords( records );
          this.updateToolbarFields( true );
          this.reloadNotAttachedTable();
          var records = store.getRange();
          this.callAction( this.configuration.javaScriptActions.attach, [ records ] );
        } else {
          this.updateToolbarFields( true );
        }
      }
    },
    onGroupChange: function( store, groupers, eOpts ) {
      if ( !this.isAttached() ) {
        this.resetSubGroupsFilter();
        this.loadRecords();
      }
    },
    onBeforeSync: function( options, eOpts ) {
      if ( !Ext.isEmpty( options.update ) ) {
        var modifiedColumnId = '';
        var update = options.update[0];

        Ext.iterate( update.modified, function( property ) {
          modifiedColumnId = String( property );
          return false;
        } );

        var proxy = update.store.getProxy();
        proxy.setExtraParam( 'modifiedColumnId', modifiedColumnId );

        this.getEl().mask( messages( 'pzmodule.updateinprogress' ) );
      }
    },
    onRecordUpdate: function( store, record, operation, modifiedFieldNames, eOpts ) {
      store.suspendEvents();
      var proxy = store.getProxy();
      proxy.setExtraParam( 'modifiedColumnId', null );
      this.getEl().unmask();
      if ( this.isPartialAttachmentShowMySeparatedActive() ) {
        this.reloadNotAttachedTable();
      }
      this.updateToolbarFields( true );
      var records = store.getRange();
      this.callAction( this.configuration.javaScriptActions.attach, [ records ] );
      store.resumeEvents();
    },
    onLoadException: function( proxy, response, operation, eOpts ) {
      var errorMessage = operation.getError();

      if ( Ext.isString( errorMessage ) ) {
        var msgBox = Ext.Msg.show( {
          title: messages( 'pzmodule.error' ),
          msg: errorMessage,
          buttons: Ext.Msg.OK,
          icon: 'dvnt-icon-x-circle dvnt-red-icon',
          modal: false
        } );
        this.showWindowInCenter( msgBox );
      }
    },
    onSelectionChange: function( selModel, selected, eOpts ) {
      var table = Ext.getCmp( selModel.getStore().tableId );

      if ( !Ext.isEmpty( table ) ) {
        table.updateSelectedRecordsField();
        table.updateToolbarFields( false );
      }
    },
    onDeselect: function( selModel, record, index, eOpts ) {
      var table = Ext.getCmp( selModel.getStore().tableId );

      if ( !table.isAttached() ) {
        var selections = selModel.getSelection();
        table.callAction( table.configuration.javaScriptActions.deselect, [ selections ] );
      }
    },
    onSelect: function( selModel, record, index, eOpts ) {
      var table = Ext.getCmp( selModel.getStore().tableId );

      if ( !table.isAttached() ) {
        var selections = selModel.getSelection();
        table.callAction( table.configuration.javaScriptActions.select, [ selections ] );
      }
    },
    onBeforeStateSave: function( stateful, state, eOpts ) {
      delete state.filters;

      if ( !Ext.isEmpty( state.storeState ) ) {
        delete state.storeState.groupers;
        delete state.storeState.sorters;
      }
    },
    onGroupContextMenu: function( view, node, group, e, eOpts ) {
      e.stopEvent();
      var table = view.up( 'recordtable' );

      if ( !table.isAttached() ) {
        var items = new Array();
        items.push( {
          xtype: 'menuitem',
          itemId: 'selectGroupMenuItem',
          text: messages('pzmodule.selectgroup'),
          iconCls: 'dvnt-icon-plus-square column-action-item-icon',
          table: table,
          group: group
        } );
        items.push( {
          xtype: 'menuitem',
          itemId: 'deselectGroupMenuItem',
          text: messages('pzmodule.deselectgroup'),
          iconCls: 'dvnt-icon-minus-square column-action-item-icon',
          table: table,
          group: group
        } );

        if ( table.shouldShowSubGroupsFilter( group ) ) {
          items.push( {
            xtype: 'menuitem',
            itemId: 'showSubGroupsFilterMenuItem',
            text: messages('pzmodule.filtersubgroups'),
            iconCls: 'dvnt-icon-zoom-in column-action-item-icon',
            table: table,
            group: group,
            event: e
          } );
        }

        var menu = Ext.create( 'Ext.menu.Menu', {
          items: items
        } );
        menu.showAt( [ e.getPageX(), e.getPageY() ] );
      }
    },
    onGroupCollapse: function( view, node, group, eOpts ) {
      if ( this.shouldMarkFilteredGroup() ) {
        this.markFilteredGroup();
      }
    },
    onGroupExpand: function( view, node, group, eOpts ) {
      if ( this.shouldMarkFilteredGroup() ) {
        this.markFilteredGroup();
      }
    },
    onSortChange: function( ct, column, direction, eOpts ) {
      var table = column.up( 'recordtable' );

      if ( !( table.isAttached() || table.blockFirstSort ) ) {
        table.loadRecords();
      } else {
        table.blockFirstSort = false;
      }
    },
    onColumnVisibilityToggle: function( ct, column, eOpts ) {
      var table = column.up( 'recordtable' );

      if ( table.shouldRefreshPanelFilters() ) {
        table.refreshPanelFilters();
      }
    }
  } );
}( this.Ext4 ) );
