( function( Ext ) {
	var messages = Suncode.context( 'pzmodule' ).messages;
	
    Ext.define( 'Suncode.pzmodule.controller.button.RecordTableButtonController', {
        extend: 'Ext.app.Controller',
        init: function() {
            this.control( {
            	  'recordtable button[itemId=clearFiltersButton]': {
                	click: this.clearFilters
                },
            	  'recordtable button[itemId=attachButton]': {
                	click: this.attach
                },
                'recordtable component[itemId=selectAllButton]': {
                	click: this.selectAll
                },
                'recordtable component[itemId=deselectAllButton]': {
                	click: this.deselectAll
                },
                'recordtable component[itemId=collapseGroupsButton]': {
                  click: this.collapseGroups
                },
                'recordtable component[itemId=expandGroupsButton]': {
                  click: this.expandGroups
                },
                'recordtable button[itemId=detachButton]': {
                	click: this.detach
                },
                'recordtable button[itemId=detachAllButton]': {
                	click: this.detachAll
                },
                'recordtable button[itemId=saveButton]': {
                	click: this.save
                },
                'recordtable button[itemId=closeButton]': {
                	click: this.close
                }
            } );
        },
        clearFilters: function( button, e, eOpts ) {
        	var table = button.up( 'recordtable' );
        	table.clearFilters();
        },
        attach: function( button, e, eOpts ) {
        	var table = button.up( 'recordtable' );
        	var selModel = table.getSelectionModel();
        	var selections = selModel.getSelection();
        	
        	if ( !Ext.isEmpty( selections ) ) {
        		var configuration = table.configuration;
        		
        		if ( configuration.attachmentWindow ) {
        			var recordsCopy = new Array();
        			Ext.each( selections, function( record, index, records ) {
        				recordsCopy.push( record.getData() );
        			} );
        			
        			var win = Ext.create( 'Suncode.pzmodule.view.window.AttachmentWindow', {
                		table: table,
                		records: recordsCopy
                	} ).show();
        			this.showWindowInCenterOfTablesPanel( win, table );
        		} else {
        			table.attach( selections );
        		}
        	} else {
        		this.showChooseRecordsWarning( table );
        	}
        },
        selectAll: function( component, e, eOpts ) {
        	var table = component.up( 'recordtable' );
        	var store = table.getStore();
        	var options = {
        		action: 'read',
        		start: 0,
        		limit: 0,
        		params: {
        			preventSort: true,
        			preventCount: true,
        			preventAmount: true
        		}
        	};
        	
        	var filtersFeature = table.getView().getFeature( 'filters' );
        	if ( !Ext.isEmpty( filtersFeature ) ) {
        		filtersFeature.onBeforeLoad( store, options );
        	}
        	
        	var operation = new Ext.data.Operation( options );
        	store.getProxy().read( operation, this.selectAllCallback, table );
        },
        selectAllCallback: function( operation ) {
        	var table = this;
        	
        	if ( operation.wasSuccessful() ) {
        		var records = operation.getRecords();
        		table.selectRecords( records );
        	}
        },
        deselectAll: function( component, e, eOpts ) {
        	var table = component.up( 'recordtable' );
        	table.deselectAll();
        },
        detach: function( button, e, eOpts ) {
        	var table = button.up( 'recordtable' );
        	var selModel = table.getSelectionModel();
        	var selections = selModel.getSelection();
        	
        	if ( !Ext.isEmpty( selections ) ) {
        		table.detach( selections );
        	} else {
        		this.showChooseRecordsWarning( table );
        	}
        },
        detachAll: function( button, e, eOpts ) {
        	var table = button.up( 'recordtable' );
        	table.detachAll();
        },
        collapseGroups: function( button, e, eOpts ) {
          var table = button.up( 'recordtable' );
          var groupingFeature = table.getView().getFeature( 'multigrouping' );

          if ( !Ext.isEmpty( groupingFeature ) ) {
            groupingFeature.collapseAll();
          }
        },
        expandGroups: function( button, e, eOpts ) {
          var table = button.up( 'recordtable' );
          var groupingFeature = table.getView().getFeature( 'multigrouping' );

          if ( !Ext.isEmpty( groupingFeature ) ) {
            groupingFeature.expandAll();
          }
        },
        save: function( button, e, eOpts ) {
        	var table = button.up( 'recordtable' );
        	
        	if ( table.configuration.save.askBeforeSave ) {
        		var msgBox = Ext.Msg.show( {
                    title: messages( 'pzmodule.saving' ),
                    msg: messages( 'pzmodule.saveandclose' ),
                    buttons: Ext.Msg.YESNO,
                    fn: function( buttonId, text, opt ) {
                    	if ( buttonId == 'yes' ) {
                    		this.doSave( table );
                    	}
                    },
                    scope: this,
					          icon: 'dvnt-icon-underscore-circle dvnt-table-gray-icon'
                } );
        		this.showWindowInCenterOfTablesPanel( msgBox, table );
        	} else {
        		this.doSave( table );
        	}
        },
        doSave: function( table ) {
        	this.maskModule( table, messages( 'pzmodule.savinginprogress' ) );
        	var attachedRecords = table.getRawRecords();
        		
        	Ext.Ajax.request( {
        		table: table,
                url: 'api/save',
                method: 'POST',
                params: {
                	configurationId: table.configuration.configurationId,
                    processId : Suncode.context( 'pzmodule' ).processId,
                    activityId: Suncode.context( 'pzmodule' ).activityId,
                    parentValues: Ext.JSON.encode( {
                    	configurationId: Suncode.context( 'pzmodule' ).parentConfigurationId,
                        processId: Suncode.context( 'pzmodule' ).parentProcessId,
                    } ),
                    attachedRecords: Ext.JSON.encode( attachedRecords ),
                    initiallyAttachedRecords: Ext.JSON.encode( table.getInitiallyAttachedRecords() )
                },
                timeout: 900000,
                scope: this,
                success: this.onSaveSuccess,
                failure: this.onSaveError
            } );
        },
        onSaveSuccess: function( response, options ) {
        	var result = Ext.JSON.decode( response.responseText );
        	
        	if ( result.success ) {
            Suncode.context( 'pzmodule' ).shouldLogPluginCloseAudit = false;
        		this.goBack();
        	} else {
        		this.showSaveError( result.message, options.table );
        		
        		if ( !result.saveValid && !Ext.isEmpty( result.validationErrors ) ) {
        			this.markSaveValidationErrors( options.table, result.validationErrors );
        		}
        	}
        },
        onSaveError: function( response, options ) {
        	this.showSaveError( messages( 'pzmodule.saveerror' ), options.table );
        },
        showSaveError: function( errorMessage, table ) {
        	this.unmaskModule( table );

          if ( Ext.isString( errorMessage ) ) {
            var msgBox = Ext.Msg.show( {
              title: messages( 'pzmodule.error' ),
              maxWidth: 400,
              msg: errorMessage,
              buttons: Ext.Msg.OK,
              icon: 'dvnt-icon-x-circle dvnt-red-icon'
            } );
            this.showWindowInCenterOfTablesPanel( msgBox, table );
          }
        },
        markSaveValidationErrors: function ( table, errors ) {
        	var store = table.getStore();
        	var configuration = table.configuration;
        	
        	Ext.each( errors, function( error, index, allErrors ) {
        		var rowIndex = store.indexOfId( error.primaryKeyValue );
        		
        		if ( rowIndex != -1 ) {
        			if ( error.amountError ) {
        				var amountColumnId = configuration.partialAttachmentConfiguration.amountColumnId;
        				
        				table.markErrorCell( rowIndex, amountColumnId );
        			} else {
        				table.markErrorRow( rowIndex );
        			}
        		}
        	} );
        },
        close: function( button, e, eOpts ) {
        	var table = button.up( 'recordtable' );
        	
        	if ( table.configuration.save.askBeforeClose ) {
        		var msgBox = Ext.Msg.show( {
                    title: messages( 'pzmodule.closing' ),
                    msg: messages( 'pzmodule.closewithoutsave' ),
                    buttons: Ext.Msg.YESNO,
                    fn: function( buttonId, text, opt ) {
                    	if ( buttonId == 'yes' ) {
                    		this.doClose( table );
                    	}
                    },
                    scope: this,
                    icon: 'dvnt-icon-underscore-circle dvnt-table-gray-icon'
                } );
        		this.showWindowInCenterOfTablesPanel( msgBox, table );
        	} else {
        		this.doClose( table );
        	}
        },
        doClose: function( component ) {
        	this.maskModule( component, messages( 'pzmodule.closinginprogress' ) );
          logPluginCloseAudit();
          Suncode.context( 'pzmodule' ).shouldLogPluginCloseAudit = false;
          this.goBack();
        },
        goBack: function() {
          history.back();
        },
        maskModule: function( component, message ) {
        	var mainPanel = component.up( 'mainpanel' );
        	mainPanel.getEl().mask( message );
        },
        unmaskModule: function( component ) {
        	var mainPanel = component.up( 'mainpanel' );
        	mainPanel.unmask();
        },
        showChooseRecordsWarning: function( table ) {
        	var msgBox = Ext.Msg.show( {
                title: messages( 'pzmodule.warning' ),
                msg: messages( 'pzmodule.chooserecords' ),
                buttons: Ext.Msg.OK,
				icon: 'dvnt-icon-exclamation-triangle dvnt-red-icon'
            } );
        	this.showWindowInCenterOfTablesPanel( msgBox, table );
        },
        showWindowInCenterOfTablesPanel: function( win, table ) {
        	var tablesPanel = table.up( 'container[itemId=tablesPanel]' );
    		var x = tablesPanel.getX() + tablesPanel.getWidth() / 2 - win.getWidth() / 2;
        	var y = tablesPanel.getY() + tablesPanel.getHeight() / 2 - win.getHeight() / 2;
        	win.setXY( [ x, y ] );
        }
    } );
}( this.Ext4 ) );