( function( Ext ) {
    var messages = Suncode.context( 'pzmodule' ).messages;

    Ext.define( 'Suncode.pzmodule.view.window.ManageConfigurationWindow', {
        extend: 'Ext.window.Window',
        alias: 'widget.manageconfigurationwindow',
        modal: true,
        initComponent: function() {
        	var idOfConfiguration = this.idOfConfiguration;
        	
        	this.items = [ {
                xtype: 'form',
                frame: false,
                border: 0,
                buttonAlign: 'center',
                items: [ !Ext.isEmpty( idOfConfiguration ) ? {
                	xtype: 'displayfield',
                    fieldLabel: messages( 'pzmodule.id' ),
                    labelSeparator: '',
                    name: 'configurationId',
                    width: 400,
                    submitValue: true
                } : {
                    xtype: 'textfield',
                    allowBlank: false,
                    maxLength: 128,
                    fieldLabel: messages( 'pzmodule.id' ),
                    labelSeparator: '',
                    name: 'configurationId',
                    width: 400
                }, {
                    xtype: 'textfield',
                    allowBlank: false,
                    maxLength: 256,
                    fieldLabel: messages( 'pzmodule.name' ),
                    labelSeparator: '',
                    name: 'name',
                    width: 400
                }, {
                    xtype: 'textarea',
                    fieldLabel: messages( 'pzmodule.description' ),
                    labelSeparator: '',
                    name: 'description',
                    width: 400,
                    height: 150
                }, {
                    xtype: 'checkbox',
                    fieldLabel: messages( 'pzmodule.usefile' ),
                    labelSeparator: '',
                    name: 'useFile',
                    uncheckedValue: 'false',
                    hidden: Ext.isEmpty( idOfConfiguration ),
                    checked: true
                }, {
                    xtype: 'fileuploadfield',
                    allowBlank: false,
                    buttonText: '',
                    fieldLabel: messages( 'pzmodule.xmlfile' ),
                    labelSeparator: '',
                    name: 'file',
                    regex: new RegExp( '.xml$', 'i' ),
                    regexText: messages( 'pzmodule.noxml' ),
                    width: 400
                } ],
                buttons: [ !Ext.isEmpty( idOfConfiguration ) ? {
                    itemId: 'editConfigurationButton',
                    text: messages( 'pzmodule.edit' ),
                    iconCls: 'dvnt-icon-edit'
                } : {
                    itemId: 'addConfigurationButton',
                    text: messages( 'pzmodule.add' ),
                    iconCls: 'dvnt-icon-plus-circle'
                }, {
                    itemId: 'closeWindowButton',
                    text: messages( 'pzmodule.cancel' ),
                    iconCls: 'dvnt-icon-x-symbol'
                } ]
            } ];
        	
            this.callParent( arguments );
        }
    } );
}( this.Ext4 ) );