/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.rest;

import com.suncode.plugin.pzmodule.api.dto.settings.SettingsDto;
import com.suncode.plugin.pzmodule.exception.SaveSettingsException;
import com.suncode.plugin.pzmodule.service.settings.SettingsService;
import com.suncode.plugin.pzmodule.web.rest.support.DatumResult;
import com.suncode.plugin.pzmodule.web.rest.support.RestUtils;
import com.suncode.plugin.pzmodule.web.rest.support.Result;
import com.suncode.plugin.pzmodule.web.rest.support.builder.ResultBuilder;
import com.suncode.plugin.pzmodule.web.rest.support.form.SaveSettingsForm;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/settings"})
public class SettingsController {
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private ResultBuilder resultBuilder;

    @RequestMapping(value={"read"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SettingsDto> read(@RequestParam boolean attached, @RequestParam String configurationId) {
        String userId = RestUtils.getUserIdFromSession();
        return this.settingsService.find(attached, userId, configurationId);
    }

    @RequestMapping(value={"/read/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public DatumResult<SettingsDto> load(@PathVariable(value="id") Long id) {
        return this.settingsService.find(id);
    }

    @RequestMapping(value={"/setasdefault/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Result setAsDefault(@PathVariable(value="id") Long id, @RequestParam boolean attached, @RequestParam String configurationId) {
        String userId = RestUtils.getUserIdFromSession();
        return this.settingsService.setAsDefault(id, attached, userId, configurationId);
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    @ResponseBody
    public Result create(SaveSettingsForm form) {
        String userId = RestUtils.getUserIdFromSession();
        try {
            this.settingsService.add(userId, form);
            return this.buildSuccessResult();
        }
        catch (SaveSettingsException exception) {
            return this.buildErrorResult(exception.getMessage());
        }
    }

    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable(value="id") Long id) {
        this.settingsService.remove(id);
    }

    private Result buildSuccessResult() {
        return this.resultBuilder.build();
    }

    private Result buildErrorResult(String message) {
        return this.resultBuilder.buildError(message);
    }
}

