/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.service.settings;

import com.suncode.plugin.pzmodule.api.dto.settings.SettingsDto;
import com.suncode.plugin.pzmodule.dao.settings.SettingsDao;
import com.suncode.plugin.pzmodule.exception.SaveSettingsException;
import com.suncode.plugin.pzmodule.model.settings.Settings;
import com.suncode.plugin.pzmodule.service.settings.SettingsService;
import com.suncode.plugin.pzmodule.translation.Translator;
import com.suncode.plugin.pzmodule.web.rest.support.DatumResult;
import com.suncode.plugin.pzmodule.web.rest.support.Result;
import com.suncode.plugin.pzmodule.web.rest.support.builder.DatumResultBuilder;
import com.suncode.plugin.pzmodule.web.rest.support.builder.ResultBuilder;
import com.suncode.plugin.pzmodule.web.rest.support.form.SaveSettingsForm;
import com.suncode.plugin.pzmodule.web.support.dto.settings.builder.SettingsDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.settings.extractor.SaveSettingsFormExtractor;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SettingsServiceImpl
implements SettingsService {
    private static final String DUPLICATE_NAME_MESSAGE = "pzmodule.program.settings.duplicate";
    private static final String NOT_FOUND_MESSAGE = "pzmodule.program.settings.notfound";
    @Autowired
    private SettingsDao settingsDao;
    @Autowired
    private SettingsDtoBuilder settingsDtoBuilder;
    @Autowired
    private DatumResultBuilder<SettingsDto> settingsDatumResultBuilder;
    @Autowired
    private ResultBuilder resultBuilder;
    @Autowired
    private SaveSettingsFormExtractor saveSettingsFormExtractor;
    @Autowired
    private Translator translator;

    @Override
    @Transactional(readOnly=true)
    public List<SettingsDto> find(boolean attached, String ownerId, String configurationId) {
        List<Settings> settings = this.settingsDao.getUserSettings(attached, ownerId, configurationId);
        return this.settingsDtoBuilder.buildBasic(settings);
    }

    @Override
    @Transactional(readOnly=true)
    public DatumResult<SettingsDto> find(Long id) {
        Settings settings = (Settings)this.settingsDao.get(id);
        if (settings != null) {
            SettingsDto dto = this.settingsDtoBuilder.build(settings);
            return this.settingsDatumResultBuilder.build(dto);
        }
        String message = this.buildNotFoundMessage();
        return this.settingsDatumResultBuilder.buildError(message);
    }

    @Override
    @Transactional
    public Result setAsDefault(Long id, boolean attached, String ownerId, String configurationId) {
        Settings settings = (Settings)this.settingsDao.get(id);
        if (settings != null) {
            Settings defaultSettings = this.settingsDao.getDefaultUserSettings(attached, ownerId, configurationId);
            settings.setIsDefault(true);
            this.settingsDao.save(settings);
            if (defaultSettings != null) {
                defaultSettings.setIsDefault(false);
                this.settingsDao.update(defaultSettings);
            }
            return this.resultBuilder.build();
        }
        String message = this.buildNotFoundMessage();
        return this.resultBuilder.buildError(message);
    }

    @Override
    @Transactional
    public void add(String ownerId, SaveSettingsForm form) throws SaveSettingsException {
        Settings settings = this.settingsDao.getUserSettingsByName(form.getAttached(), ownerId, form.getConfigurationId(), form.getName());
        if (settings == null) {
            settings = this.saveSettingsFormExtractor.extract(ownerId, form);
            Settings defaultSettings = null;
            if (BooleanUtils.isTrue((Boolean)form.getIsDefault())) {
                defaultSettings = this.settingsDao.getDefaultUserSettings(form.getAttached(), ownerId, form.getConfigurationId());
            }
            this.settingsDao.save(settings);
            if (defaultSettings != null) {
                defaultSettings.setIsDefault(false);
                this.settingsDao.update(defaultSettings);
            }
        } else {
            String message = this.buildDuplicateNameMessage();
            throw new SaveSettingsException(message);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public SettingsDto getDefault(boolean attached, String ownerId, String configurationId) {
        Settings settings = this.settingsDao.getDefaultUserSettings(attached, ownerId, configurationId);
        if (settings != null) {
            return this.settingsDtoBuilder.build(settings);
        }
        return null;
    }

    @Override
    @Transactional
    public void remove(Long id) {
        Settings settings = (Settings)this.settingsDao.get(id);
        if (settings != null) {
            this.settingsDao.delete(settings);
        }
    }

    @Override
    @Transactional
    public void remove(String configurationId) {
        List<Settings> settings = this.settingsDao.getConfigurationSettings(configurationId);
        if (CollectionUtils.isNotEmpty(settings)) {
            for (Settings oneSettings : settings) {
                this.settingsDao.delete(oneSettings);
            }
        }
    }

    private String buildNotFoundMessage() {
        return this.translator.translateMessage(NOT_FOUND_MESSAGE);
    }

    private String buildDuplicateNameMessage() {
        return this.translator.translateMessage(DUPLICATE_NAME_MESSAGE);
    }
}

