/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.service.document;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.DocumentFilterDto;
import com.suncode.plugin.pzmodule.api.dto.document.DocumentDto;
import com.suncode.plugin.pzmodule.api.enumeration.DocumentFilterType;
import com.suncode.plugin.pzmodule.provider.record.InternalRecordProviderImpl;
import com.suncode.plugin.pzmodule.service.document.DocumentService;
import com.suncode.plugin.pzmodule.web.support.dto.document.builder.DocumentDtoBuilder;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.FileSorter;
import com.suncode.pwfl.util.FinderFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
implements DocumentService {
    private static final Logger LOG = Logger.getLogger(InternalRecordProviderImpl.class);
    @Autowired
    private DocumentDtoBuilder documentDtoBuilder;

    @Override
    public List<DocumentDto> getActivityDocuments(ConfigurationDto configuration, String processId, String activityId) {
        List<WfFile> files = this.getActivityFiles(configuration, processId, activityId);
        return this.documentDtoBuilder.build(files, processId, activityId);
    }

    private List<WfFile> getActivityFiles(ConfigurationDto configuration, String processId, String activityId) {
        FileFinder fileFinder = FinderFactory.getFileFinder();
        List files = fileFinder.getDocumentsFromActivity(processId, activityId, FileSorter.ATTACH_TO_PROCESS_DATE_SORTER, new String[]{"documentClass"});
        return this.filterActivityDocuments(configuration, files);
    }

    private List<WfFile> filterActivityDocuments(ConfigurationDto configuration, List<WfFile> files) {
        return files.stream().filter(f -> this.isAcceptedActivityDocument(configuration, (WfFile)f)).collect(Collectors.toList());
    }

    private boolean isAcceptedActivityDocument(ConfigurationDto configuration, WfFile file) {
        try {
            boolean isAccepted = true;
            List<DocumentFilterDto> documentFilters = configuration.getPanelsConfiguration().getDocumentFilters();
            if (CollectionUtils.isNotEmpty(documentFilters)) {
                for (DocumentFilterDto documentFilter : documentFilters) {
                    switch (DocumentFilterType.getByName(documentFilter.getType())) {
                        case FILE_NAME_REGEX: {
                            isAccepted = this.isFileNameRegexAccepted(file, documentFilter);
                            break;
                        }
                        case DOCUMENT_CLASS: {
                            isAccepted = this.isDocumentClassAccepted(file, documentFilter);
                            break;
                        }
                        default: {
                            isAccepted = false;
                        }
                    }
                    if (isAccepted) continue;
                    break;
                }
            }
            return isAccepted;
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    private boolean isFileNameRegexAccepted(WfFile file, DocumentFilterDto documentFilter) {
        return file.getFileName().matches(documentFilter.getValue());
    }

    private boolean isDocumentClassAccepted(WfFile file, DocumentFilterDto documentFilter) {
        return StringUtils.equals((CharSequence)file.getDocumentClass().getName(), (CharSequence)documentFilter.getValue());
    }
}

