/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.api.util.QueryUtils;
import com.suncode.plugin.pzmodule.object.WhereCondition;
import com.suncode.plugin.pzmodule.resolver.recordprovider.WhereConditionQueryPartResolver;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class WhereConditionQueryPartResolverImpl
implements WhereConditionQueryPartResolver {
    @Override
    public List<String> resolve(List<WhereCondition> whereConditions, ColumnTranslation columnTranslation) {
        ArrayList<String> parts = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(whereConditions)) {
            for (WhereCondition whereCondition : whereConditions) {
                parts.add(this.resolve(whereCondition, columnTranslation));
            }
        }
        return parts;
    }

    @Override
    public String resolve(WhereCondition whereCondition, ColumnTranslation columnTranslation) {
        ArrayList<String> subParts = new ArrayList<String>();
        for (String value : whereCondition.getValues()) {
            subParts.add(this.resolve(whereCondition, value, columnTranslation));
        }
        StringBuilder queryPart = new StringBuilder();
        queryPart.append("(");
        queryPart.append(StringUtils.join(subParts, (String)" OR "));
        queryPart.append(")");
        return queryPart.toString();
    }

    private String resolve(WhereCondition whereCondition, String value, ColumnTranslation columnTranslation) {
        StringBuilder subPart = new StringBuilder();
        subPart.append(columnTranslation.getTranslation(whereCondition.getKey()));
        subPart.append(whereCondition.getOperator().getSign());
        subPart.append(whereCondition.getSuffix());
        subPart.append(QueryUtils.getSafeValue(value));
        subPart.append(whereCondition.getSuffix());
        return subPart.toString();
    }
}

