/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.executor.save.record;

import com.suncode.plugin.pzmodule.api.dto.configuration.ColumnDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PrimaryKeyDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionParameterDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.enumeration.RecordLocation;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionParameterType;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.executor.save.record.SaveActionExecutor;
import com.suncode.plugin.pzmodule.resolver.configuration.ConfigurationResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.ColumnTypesResolver;
import com.suncode.plugin.pzmodule.resolver.recordsaver.SaveActionParameterResolver;
import com.suncode.plugin.pzmodule.resolver.recordsaver.UpdateTableQueryResolver;
import com.suncode.plugin.pzmodule.service.shark.SharkService;
import com.suncode.plugin.pzmodule.translation.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="updateTableSaveActionExecutor")
public class UpdateTableSaveActionExecutorImpl
implements SaveActionExecutor {
    private static final Logger LOG = Logger.getLogger(UpdateTableSaveActionExecutorImpl.class);
    private static final String SAVE_ERROR_MESSAGE = "pzmodule.program.save.error";
    @Autowired
    private SharkService sharkService;
    @Autowired
    private ConfigurationResolver configurationResolver;
    @Autowired
    private ColumnTypesResolver columnTypesResolver;
    @Autowired
    private SaveActionParameterResolver saveActionParameterResolver;
    @Autowired
    private UpdateTableQueryResolver updateTableQueryResolver;
    @Autowired
    private Translator translator;

    @Override
    public void execute(SharkTransaction sharkTransaction, Session session, ConfigurationDto configuration, SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords) throws SaveActionExecutorException {
        if (this.isDatabaseTableRecordLocation(configuration)) {
            try {
                Map<String, Object> activityContext = this.getActivityContext(sharkTransaction, saveInfo.getProcessId(), saveInfo.getActivityId());
                this.execute(session, configuration, saveAction, saveInfo, attachedRecords, activityContext);
            }
            catch (SaveActionExecutorException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOG.error((Object)exception.getMessage(), (Throwable)exception);
                throw new SaveActionExecutorException(this.buildSaveErrorMessage());
            }
        }
    }

    private boolean isDatabaseTableRecordLocation(ConfigurationDto configuration) {
        RecordLocation recordLocation = RecordLocation.getByName(configuration.getSearch().getLocation().getType());
        return recordLocation.equals((Object)RecordLocation.DATABASE_TABLE);
    }

    private Map<String, Object> getActivityContext(SharkTransaction sharkTransaction, String processId, String activityId) throws BaseException, ConnectFailed, NotConnected {
        return this.sharkService.getActivityContext(sharkTransaction, processId, activityId);
    }

    private void execute(Session session, ConfigurationDto configuration, SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords, Map<String, Object> activityContext) throws SaveActionExecutorException {
        List<Record> detachedRecords;
        List<ColumnDto> columns = this.configurationResolver.resolveColumns(configuration, false);
        Map<String, ColumnType> columnTypes = this.columnTypesResolver.resolve(columns);
        String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
        ArrayList<String> attachedPrimaryKeyValues = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(attachedRecords)) {
            for (Record record : attachedRecords) {
                String primaryKeyValue = record.getValue(primaryKeyName);
                attachedPrimaryKeyValues.add(primaryKeyValue);
            }
            this.execute(session, configuration, columnTypes, saveAction, saveInfo, attachedRecords, activityContext, SaveActionParameterType.ATTACH);
        }
        if (CollectionUtils.isNotEmpty(detachedRecords = this.getDetachedRecords(saveInfo, attachedPrimaryKeyValues, primaryKeyName))) {
            this.execute(session, configuration, columnTypes, saveAction, saveInfo, detachedRecords, activityContext, SaveActionParameterType.DETACH);
        }
    }

    private void execute(Session session, ConfigurationDto configuration, Map<String, ColumnType> columnTypes, SaveActionDto saveAction, SaveInfo saveInfo, List<Record> records, Map<String, Object> activityContext, SaveActionParameterType acceptedParameterType) throws SaveActionExecutorException {
        List<SaveActionParameterDto> saveActionParameters = this.getSaveActionParameters(saveAction, acceptedParameterType);
        if (CollectionUtils.isNotEmpty(saveActionParameters)) {
            String tableName = this.configurationResolver.resolveSearchLocationName(configuration, false);
            PrimaryKeyDto primaryKey = configuration.getSearch().getLocation().getPrimaryKey();
            for (Record record : records) {
                String query = this.updateTableQueryResolver.resolve(tableName, primaryKey, columnTypes, saveActionParameters, saveInfo, record, records, activityContext);
                this.execute(session, query);
            }
        }
    }

    private List<SaveActionParameterDto> getSaveActionParameters(SaveActionDto saveAction, SaveActionParameterType acceptedParameterType) {
        return this.saveActionParameterResolver.resolve(saveAction.getParameters(), acceptedParameterType);
    }

    private List<Record> getDetachedRecords(SaveInfo saveInfo, List<String> attachedPrimaryKeyValues, String primaryKeyName) {
        ArrayList<Record> records = new ArrayList<Record>();
        if (CollectionUtils.isNotEmpty(saveInfo.getInitiallyAttachedRecords())) {
            for (Record record : saveInfo.getInitiallyAttachedRecords()) {
                String primaryKeyValue = record.getValue(primaryKeyName);
                if (attachedPrimaryKeyValues.contains(primaryKeyValue)) continue;
                records.add(record);
            }
        }
        return records;
    }

    private void execute(Session session, String query) {
        NativeQuery sqlQuery = session.createSQLQuery(query);
        sqlQuery.executeUpdate();
    }

    private String buildSaveErrorMessage() {
        return this.translator.translateMessage(SAVE_ERROR_MESSAGE);
    }
}

