/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.api.enumeration;

import com.plusmpm.database.dbspecific.NativeDatabase;
import com.suncode.plugin.pzmodule.api.info.support.Filter;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.api.util.QueryUtils;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FilterType {
    DATE("date"){

        @Override
        public String buildQueryPart(List<Filter> filters, Map<String, String> dateStringInputFormats, ColumnTranslation columnTranslation) {
            Filter filter = filters.get(0);
            StringBuilder part = new StringBuilder();
            part.append(columnTranslation.getTranslation(filter.getField()));
            part.append(filter.getComparison().getSign());
            part.append("'");
            part.append(this.getFilterValue(filter, dateStringInputFormats));
            part.append("'");
            return part.toString();
        }

        private Object getFilterValue(Filter filter, Map<String, String> dateStringInputFormats) {
            Object value = filter.getValue();
            String columnId = filter.getField();
            if (value != null && dateStringInputFormats.containsKey(columnId)) {
                String inputFormat = dateStringInputFormats.get(columnId);
                return this.convertDateString(value.toString(), inputFormat);
            }
            return value;
        }

        private String convertDateString(String value, String inputFormat) {
            if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)inputFormat)) {
                return value;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            dateFormat.applyPattern("yyyy-MM-dd");
            try {
                Date date = dateFormat.parse(value);
                dateFormat.applyPattern(inputFormat);
                return dateFormat.format(date);
            }
            catch (ParseException exception) {
                LOG.error((Object)exception.getMessage(), (Throwable)exception);
                return value;
            }
        }
    }
    ,
    INT("int"){

        @Override
        public String buildQueryPart(List<Filter> filters, Map<String, String> dateStringInputFormats, ColumnTranslation columnTranslation) {
            Filter filter = filters.get(0);
            StringBuilder part = new StringBuilder();
            part.append(columnTranslation.getTranslation(filter.getField()));
            part.append(filter.getComparison().getSign());
            part.append(filter.getValue());
            return part.toString();
        }
    }
    ,
    FLOAT("float"){

        @Override
        public String buildQueryPart(List<Filter> filters, Map<String, String> dateStringInputFormats, ColumnTranslation columnTranslation) {
            Filter filter = filters.get(0);
            StringBuilder part = new StringBuilder();
            part.append(columnTranslation.getTranslation(filter.getField()));
            part.append(filter.getComparison().getSign());
            part.append(filter.getValue());
            return part.toString();
        }
    }
    ,
    NUMERIC("numeric"){

        @Override
        public String buildQueryPart(List<Filter> filters, Map<String, String> dateStringInputFormats, ColumnTranslation columnTranslation) {
            Filter filter = filters.get(0);
            StringBuilder part = new StringBuilder();
            part.append(columnTranslation.getTranslation(filter.getField()));
            part.append(filter.getComparison().getSign());
            part.append(filter.getValue());
            return part.toString();
        }
    }
    ,
    STRING("string"){
        private static final String SUB_VALUES_SEPARATOR = ";";

        @Override
        public String buildQueryPart(List<Filter> filters, Map<String, String> dateStringInputFormats, ColumnTranslation columnTranslation) {
            ArrayList relatedSubParts = new ArrayList();
            int longest = 0;
            for (Filter filter : filters) {
                String[] subValues;
                ArrayList<String> subParts = new ArrayList<String>();
                for (String subValue : subValues = StringUtils.split((String)((String)filter.getValue()), (String)SUB_VALUES_SEPARATOR)) {
                    subParts.add(this.buildQueryPartSubPart(filter.getField(), subValue, columnTranslation));
                }
                relatedSubParts.add(subParts);
                if (subValues.length <= longest) continue;
                longest = subValues.length;
            }
            ArrayList<CallSite> relatedParts = new ArrayList<CallSite>();
            for (int i = 0; i < longest; ++i) {
                ArrayList<String> relatedPart = new ArrayList<String>();
                for (List list : relatedSubParts) {
                    if (list.size() <= i) continue;
                    relatedPart.add((String)list.get(i));
                }
                relatedParts.add((CallSite)((Object)("(" + StringUtils.join(relatedPart, (String)" AND ") + ")")));
            }
            return "(" + StringUtils.join(relatedParts, (String)" OR ") + ")";
        }

        private String buildQueryPartSubPart(String field, String subValue, ColumnTranslation columnTranslation) {
            StringBuilder subPart = new StringBuilder();
            subPart.append(NativeDatabase.getImplementation().getCaseInsensitiveComparisonQueryPart(columnTranslation.getTranslation(field)));
            subPart.append(" like ");
            subPart.append(NativeDatabase.getImplementation().getCaseInsensitiveComparisonQueryPart(this.buildQueryPartValue(subValue)));
            return subPart.toString();
        }

        private String buildQueryPartValue(String filterValue) {
            StringBuilder value = new StringBuilder();
            value.append("'%");
            value.append(QueryUtils.getSafeValue(filterValue));
            value.append("%'");
            return value.toString();
        }
    };

    private static final Logger LOG;
    private String name;

    private FilterType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static FilterType getByName(String name) {
        for (FilterType filterType : FilterType.values()) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)filterType.getName())) continue;
            return filterType;
        }
        return STRING;
    }

    public abstract String buildQueryPart(List<Filter> var1, Map<String, String> var2, ColumnTranslation var3);

    static {
        LOG = Logger.getLogger(FilterType.class);
    }
}

