( function( Ext ) {
    var messages = Suncode.context( 'pzmodule' ).messages;

    Ext.define( 'Suncode.pzmodule.view.window.SaveSettingsWindow', {
        id: 'savesettingswindow',
        extend: 'Ext.window.Window',
        alias: 'widget.savesettingswindow',
        title: messages( 'pzmodule.settingssaving' ),
        modal: true,
        items: [ {
            xtype: 'form',
            frame: false,
            border: 0,
            buttonAlign: 'center',
            items: [ {
                xtype: 'textfield',
                allowBlank: false,
                maxLength: 256,
                fieldLabel: messages( 'pzmodule.name' ),
                labelSeparator: '',
                name: 'name',
                width: 400
            }, {
                xtype: 'checkbox',
                fieldLabel: messages( 'pzmodule.default' ),
                labelSeparator: '',
                name: 'isDefault',
                uncheckedValue: 'false'
            }, {
              xtype: 'checkbox',
              fieldLabel: messages( 'pzmodule.shared' ),
              labelSeparator: '',
              name: 'shared',
              uncheckedValue: 'false'
            } ],
            buttons: [ {
                xtype: 'button',
                itemId: 'saveSettingsButton',
                text: messages( 'pzmodule.save' ),
                iconCls: 'dvnt-icon-save'
            }, {
                xtype: 'button',
                itemId: 'cancelButton',
                text: messages( 'pzmodule.cancel' ),
                iconCls: 'dvnt-icon-x-symbol'
            } ],
        } ],
        initComponent: function() {
            this.callParent( arguments );
        }
    } );
}( this.Ext4 ) );