( function( Ext ) {
    var messages = Suncode.context( 'pzmodule' ).messages;

    Ext.define( 'Suncode.pzmodule.view.window.AttachmentWindow', {
        extend: 'Ext.window.Window',
        alias: 'widget.attachmentwindow',
        requires: [ 'Suncode.pzmodule.view.table.AttachmentTable' ],
        id: 'pz_attaching_window',
        title: messages( 'pzmodule.attachment' ),
        modal: true,
        initComponent: function() {
        	var table = this.table;
        	
        	this.items = [ {
                xtype: 'form',
                frame: false,
                border: 0,
                buttonAlign: 'center',
                items: [ Ext.create( 'Suncode.pzmodule.view.table.AttachmentTable', {
            		width: table.getWidth() * 0.8,
            		height: 400,
            		table: table,
            		records: this.records
            	} ) ],
                buttons: [ {
                    xtype: 'button',
                    id: 'pz_confirm_attach_button',
                    itemId: 'confirmAttachmentButton',
                    text: messages( 'pzmodule.confirm' ),
                    iconCls: 'dvnt-icon-check-symbol'
                }, {
                    xtype: 'button',
                    id: 'pz_delete_record_attach_button',
                    itemId: 'deleteRecordsButton',
                    text: messages( 'pzmodule.delete' ),
                    iconCls: 'dvnt-icon-delete'
                }, {
                    xtype: 'button',
                    id: 'pz_cancel_attach_button',
                    itemId: 'cancelButton',
                    text: messages( 'pzmodule.cancel' ),
                    iconCls: 'dvnt-icon-x-symbol'
                } ]
            } ];
    
            this.callParent( arguments );
        }
    } );
}( this.Ext4 ) );