( function( Ext ) {
    Ext.define( 'Suncode.pzmodule.view.toolbar.RecordTablePagingToolbar', {
        extend: 'Ext.toolbar.Paging',
        alias: 'widget.recordtablepagingtoolbar',
        prependButtons: true,
        excludeFirstPageButton: false,
        excludeLastPageButton: false,
        initComponent: function() {
            this.callParent();
        },
        getPagingItems: function() {
            var me = this;
            var items = new Array();
            
            if ( !me.excludeFirstPageButton ) {
            	items.push( {
                    itemId: 'first',
                    tooltip: me.firstText,
                    overflowText: me.firstText,
                    iconCls: 'dvnt-icon-chevron-double-left',
                    disabled: true,
                    handler: me.moveFirst,
                    scope: me
                } );
            }
            items.push( {
                itemId: 'prev',
                tooltip: me.prevText,
                overflowText: me.prevText,
                iconCls: 'dvnt-icon-chevron-left',
                disabled: true,
                handler: me.movePrevious,
                scope: me
            } );
            items.push( {
                xtype: 'numberfield',
                itemId: 'inputItem',
                name: 'inputItem',
                cls: Ext.baseCSSPrefix + 'tbar-page-number',
                allowDecimals: false,
                minValue: 1,
                hideTrigger: true,
                enableKeyEvents: true,
                keyNavEnabled: false,
                selectOnFocus: true,
                submitValue: false,
                isFormField: false,
                width: me.inputItemWidth,
                margins: '-1 2 3 2',
                listeners: {
                    scope: me,
                    keydown: me.onPagingKeyDown,
                    blur: me.onPagingBlur
                }
            } );
            items.push( {
                xtype: 'tbtext',
                itemId: 'afterTextItem',
                text: Ext.String.format(me.afterPageText, 1)
            } );
            items.push( {
                itemId: 'next',
                tooltip: me.nextText,
                overflowText: me.nextText,
                iconCls: 'dvnt-icon-chevron-right',
                disabled: true,
                handler: me.moveNext,
                scope: me
            } );
            if ( !me.excludeLastPageButton ) {
            	items.push( {
                    itemId: 'last',
                    tooltip: me.lastText,
                    overflowText: me.lastText,
                    iconCls: 'dvnt-icon-chevron-double-right',
                    disabled: true,
                    handler: me.moveLast,
                    scope: me
                } );
            }
            
            return items;
        }
    } );
}( this.Ext4 ) );