(function (Ext) {
  Ext.define('Suncode.pzmodule.view.panel.MainPanel', {
    extend: 'Ext.container.Container',
    alias: 'widget.mainpanel',
    requires: ['Suncode.pzmodule.view.table.RecordTable',
      'Suncode.pzmodule.view.panel.DocumentsPanel',
      'Suncode.pzmodule.view.button.ExtraButton'],
    id: 'pz_main_panel',
    layout: 'border',
    defaults: {
      split: true
    },
    initComponent: function () {
      var configuration = this.configuration;
      var items = new Array();
      items.push({
        xtype: 'container',
        id: 'pz_left_panel',
        itemId: 'tablesPanel',
        region: 'center',
        width: '50%',
        layout: 'border',
        defaults: {
          split: true
        },
        items: [Ext.create('Suncode.pzmodule.view.table.RecordTable', {
          id: 'pz_not_attached_grid',
          stateId: 'pz_not_attached_grid_state_id',
          title: configuration.panelsConfiguration.notAttachedTitle,
          region: 'north',
          height: '50%',
          columns: configuration.notAttachedColumns,
          attached: false,
          filterable: true,
          filtersType: configuration.panelsConfiguration.notAttachedFiltersType,
          storeSorters: configuration.notAttachedSorters,
          storeGroupers: configuration.groupingConfiguration.notAttachedGroupers,
          storePageSize: configuration.panelsConfiguration.notAttachedPageSize,
          pagingDisabled: configuration.panelsConfiguration.notAttachedPagingDisabled,
          groupingMenuEnabled: configuration.groupingConfiguration.notAttachedMenuEnabled,
          groupingStartCollapsed: configuration.groupingConfiguration.notAttachedStartCollapsed,
          groupingSums: configuration.groupingConfiguration.notAttachedGroupSums,
          extraButtons: configuration.notAttachedPanelButtons,
          toolbarFields: configuration.notAttachedPanelToolbarFields,
          configuration: configuration
        }), Ext.create('Suncode.pzmodule.view.table.RecordTable', {
          id: 'pz_attached_grid',
          stateId: 'pz_attached_grid_state_id',
          title: configuration.panelsConfiguration.attachedTitle,
          region: 'center',
          height: '50%',
          columns: configuration.attachedColumns,
          attached: true,
          filterable: false,
          storeSorters: configuration.attachedSorters,
          storeGroupers: configuration.groupingConfiguration.attachedGroupers,
          groupingMenuEnabled: configuration.groupingConfiguration.attachedMenuEnabled,
          groupingStartCollapsed: configuration.groupingConfiguration.attachedStartCollapsed,
          groupingSums: configuration.groupingConfiguration.attachedGroupSums,
          extraButtons: configuration.attachedPanelButtons,
          toolbarFields: configuration.attachedPanelToolbarFields,
          configuration: configuration
        })]
      });

      if (this.shouldBuildDocumentsPanel(configuration)) {
        items.push(Ext.create('Suncode.pzmodule.view.panel.DocumentsPanel', {
          title: configuration.panelsConfiguration.rightTitle,
          region: 'east',
          width: '50%',
          extraButtons: configuration.rightPanelButtons,
          documents: this.documents
        }));
      }

      this.items = items;

      this.callParent(arguments);
    },
    shouldBuildDocumentsPanel: function (configuration) {
      return (configuration.panelsConfiguration.rightVisible
          && !configuration.newWindowDocumentPreview);
    }
  });
}(this.Ext4));