(function (Ext) {
  Ext.define('Suncode.pzmodule.view.filter.SubGroupsFilter', {
    extend: 'Ext.container.Container',
    alias: 'widget.subgroupsfilter',
    requires: ['Suncode.pzmodule.view.field.GroupingSumColumnList'],
    width: 150,
    layout: 'form',
    initComponent: function () {
      var table = this.table;
      var configuration = table.configuration;
      var subGroupsFilter = table.getSubGroupsFilterByGroupId(this.groupId);
      var filtersMap = Ext.Array.toValueMap(subGroupsFilter.filters,
          'comparison');
      var groupingSumColumns = new Array();

      Ext.each(table.groupingSums, function (groupingSum, index, groupingSums) {
        var columnId = groupingSum.columnId;
        var column = table.getColumn(columnId);
        var columnName = columnId;

        if (!Ext.isEmpty(column)) {
          columnName = column.text;
        }

        groupingSumColumns.push({
          id: columnId,
          name: columnName
        });
      });

      this.items = [Ext.create(
          'Suncode.pzmodule.view.field.GroupingSumColumnList', {
            storeData: groupingSumColumns,
            value: Ext.isEmpty(subGroupsFilter.groupingSumColumn) ?
                table.groupingSums[0].columnId
                : subGroupsFilter.groupingSumColumn
          }), {
        xtype: 'menuseparator'
      }, {
        xtype: 'numberfield',
        fieldLabel: '>=',
        labelSeparator: '',
        labelWidth: 8,
        enableKeyEvents: true,
        allowExponential: false,
        decimalSeparator: configuration.decimalSeparator,
        decimalPrecision: 10,
        hideTrigger: true,
        keyNavEnabled: false,
        mouseWheelEnabled: false,
        value: !Ext.isEmpty(filtersMap['gt']) ? filtersMap['gt'].value : '',
        comparison: 'gt',
        listeners: {
          scope: this,
          keydown: this.onFilterKeyDown,
          keypress: this.onFilterKeyPress
        }
      }, {
        xtype: 'numberfield',
        fieldLabel: '<=',
        labelSeparator: '',
        labelWidth: 8,
        enableKeyEvents: true,
        allowExponential: false,
        decimalSeparator: configuration.decimalSeparator,
        decimalPrecision: 10,
        hideTrigger: true,
        keyNavEnabled: false,
        mouseWheelEnabled: false,
        value: !Ext.isEmpty(filtersMap['lt']) ? filtersMap['lt'].value : '',
        comparison: 'lt',
        listeners: {
          scope: this,
          keydown: this.onFilterKeyDown,
          keypress: this.onFilterKeyPress
        }
      }, {
        xtype: 'menuseparator'
      }, {
        xtype: 'numberfield',
        fieldLabel: '=',
        labelSeparator: '',
        labelWidth: 8,
        enableKeyEvents: true,
        allowExponential: false,
        decimalSeparator: configuration.decimalSeparator,
        decimalPrecision: 10,
        hideTrigger: true,
        keyNavEnabled: false,
        mouseWheelEnabled: false,
        value: !Ext.isEmpty(filtersMap['eq']) ? filtersMap['eq'].value : '',
        comparison: 'eq',
        listeners: {
          scope: this,
          keydown: this.onFilterKeyDown,
          keypress: this.onFilterKeyPress
        }
      }];

      this.initFilterTask();

      this.callParent(arguments);
    },
    initFilterTask: function () {
      this.filterTask = Ext.create('Ext.util.DelayedTask', this.filterRecords,
          this);
    },
    onFilterKeyDown: function (field, e, eOpts) {
      var key = e.getKey();

      if (key == e.ENTER) {
        e.stopEvent();
        this.onFilterKeyPress(field, e, eOpts);
      } else if (key == e.BACKSPACE || key == e.DELETE) {
        this.onFilterKeyPress(field, e, eOpts);
      }
    },
    onFilterKeyPress: function (field, e, eOpts) {
      var table = this.table;
      var configuration = table.configuration;
      var liveFiltering = configuration.liveFiltering;
      var key = e.getKey();

      if (field.isValid()) {
        this.resetFilterItems(field.comparison);

        if (liveFiltering && (!e.isSpecialKey() || key == e.ENTER || key
            == e.BACKSPACE || key == e.DELETE)) {
          this.runFilterTask(500);
        } else if (!liveFiltering && key == e.ENTER) {
          this.runFilterTask(0);
        }
      }
    },
    runFilterTask: function (delay) {
      this.filterTask.delay(delay);
    },
    resetFilterItems: function (comparison) {
      switch (comparison) {
        case 'gt':
        case 'lt':
          this.resetFilterItem('eq');
          break;
        case 'eq':
          this.resetFilterItem('gt');
          this.resetFilterItem('lt');
          break;
        default:
          break;
      }
    },
    resetFilterItem: function (comparison) {
      var filterItem = this.getFilterItem(comparison);

      if (!Ext.isEmpty(filterItem)) {
        filterItem.setValue('');
      }
    },
    getFilterItem: function (comparison) {
      return this.down('numberfield[comparison=' + comparison + ']');
    },
    filterRecords: function () {
      this.cancelFilterTask();
      var groupingSumColumn = this.getGroupingSumColumn();
      var filterValue = this.getFilterValue(groupingSumColumn);
      var table = this.table;

      if (!Ext.isEmpty(filterValue)) {
        table.updateSubGroupsFilter(this.groupId, this.groupingField,
            groupingSumColumn, filterValue);
      } else {
        table.resetSubGroupsFilter();
      }

      var store = table.getStore();
      store.loadPage(1);
    },
    cancelFilterTask: function () {
      this.filterTask.cancel();
    },
    getGroupingSumColumn: function () {
      var groupingSumColumnList = this.down('groupingsumcolumnlist');

      return groupingSumColumnList.getValue();
    },
    getFilterValue: function (groupingSumColumn) {
      var value = new Array();
      var table = this.table;

      this.items.each(function (item, index, length) {
        if (!Ext.isEmpty(item.comparison)) {
          var itemValue = item.getValue();

          if (!Ext.isEmpty(itemValue)) {
            value.push({
              type: 'float',
              field: groupingSumColumn,
              comparison: item.comparison,
              value: itemValue
            });
          }
        }
      }, this);

      return value;
    }
  });
}(this.Ext4));