(function (Ext) {
  Ext.define(
      'Suncode.pzmodule.controller.button.DocumentsPanelButtonController', {
        extend: 'Ext.app.Controller',
        init: function () {
          this.control({
            'documentspanel button[itemId=enlargeDocumentButton]': {
              click: this.enlargeDocument
            },
            'documentspanel button[itemId=closeAllButton]': {
              click: this.closeAll
            },
            'documentspanel button[itemId=restoreAllButton]': {
              click: this.restoreAll
            }
          });
        },
        enlargeDocument: function (button, e, eOpts) {
          var documentsPanel = button.up('documentspanel');
          var documentPanel = documentsPanel.getActiveTab();

          if (!Ext.isEmpty(documentPanel)) {
            var src = Suncode.context('pzmodule').contextPath + '/'
                + documentPanel.document.showFileLink;
            window.open(src);
          }
        },
        closeAll: function (button, e, eOpts) {
          var documentsPanel = button.up('documentspanel');
          documentsPanel.removeAll();
        },
        restoreAll: function (button, e, eOpts) {
          var documentsPanel = button.up('documentspanel');
          documentsPanel.removeAll();

          if (!Ext.isEmpty(documentsPanel.documents)) {
            var items = new Array();

            Ext.each(documentsPanel.documents,
                function (document, index, documents) {
                  items.push(
                      Ext.create('Suncode.pzmodule.view.panel.DocumentPanel', {
                        title: document.name,
                        document: document
                      }));
                });

            Ext.suspendLayouts();
            documentsPanel.add(items);
            Ext.resumeLayouts(true);

            var firstItem = documentsPanel.setActiveTab(0);
            firstItem.fireEvent('activate', firstItem);
          }
        }
      });
}(this.Ext4));