(function (Ext) {
  var messages = Suncode.context('pzmodule').messages;
  Suncode.context( 'pzmodule' ).shouldLogPluginCloseAudit = true;

  window.onbeforeunload = function( e ) {
    if ( Suncode.context( 'pzmodule' ).shouldLogPluginCloseAudit ) {
      logPluginCloseAudit();
    }

    return;
  };

  runPzModule = function (configuration, documents) {
    var renderTo = 'pzmodule-div';

    Ext.Loader.setConfig({
      enabled: true,
      disableCaching: false,
      paths: {
        'Ext.ux': Suncode.context('pzmodule').resources + '/scripts/ux'
      }
    });

    Ext.application({
      name: 'Suncode.pzmodule',
      appFolder: Suncode.context('pzmodule').resources + '/scripts/program',
      requires: ['Suncode.pzmodule.view.panel.MainPanel'],
      controllers: ['panel.MainPanelController', 'table.RecordTableController',
        'button.RecordTableButtonController', 'menu.RecordTableMenuController',
        'panel.DocumentPanelController',
        'button.DocumentsPanelButtonController',
        'button.SaveSettingsWindowButtonController',
        'button.SettingsWindowButtonController',
        'table.AttachmentTableController',
        'button.AttachmentWindowButtonController',
        'button.ExtraButtonController'],
      launch: function () {
        Ext.QuickTips.init();
        this.setCookieProvider();
        this.setJsonDateEncoder();
        this.initOverrides();
        this.buildView();
      },
      setCookieProvider: function () {
        var currentTime = new Date().getTime();
        var expirationTime = 1000 * 60 * 60 * 24 * 30;

        Ext.state.Manager.setProvider(new Ext.state.CookieProvider({
          expires: new Date(currentTime + expirationTime)
        }));
      },
      setJsonDateEncoder: function () {
        Ext.JSON.encodeDate = function (date) {
          return Ext.Date.format(date, '"Y-m-d"');
        };
      },
      initOverrides: function () {
        this.overrideGridFilters();
        this.overrideSelectionModel();
        this.overrideViewTable();
        this.overrideStore();
        this.overrideJsonWriter();
        this.overrideDataConnection();
      },
      overrideGridFilters: function () {
        Ext.override(Ext.ux.grid.menu.RangeMenu, {
          menuItemCfgs: {
            decimalSeparator: configuration.decimalSeparator,
            hideTrigger: true
          }
        });
        Ext.override(Ext.ux.grid.filter.DateFilter, {
          dateFormat: 'Y-m-d',
          beforeText: messages('pzmodule.before'),
          afterText: messages('pzmodule.after'),
          onText: messages('pzmodule.on')
        });
      },
      overrideSelectionModel: function () {
        Ext.override(Ext.selection.Model, {
          selectWithEvent: function (record, e, keepExisting) {
            var me = this;

            switch (me.selectionMode) {
              case 'MULTI':
                if (e.ctrlKey && me.isSelected(record)) {
                  me.doDeselect(record, false);
                } else if (e.shiftKey && me.lastFocused) {
                  me.selectRange(me.lastFocused, record, e.ctrlKey);
                } else if (e.ctrlKey) {
                  me.doSelect(record, true, false);
                } else if (me.isSelected(record) && !e.shiftKey && !e.ctrlKey
                    && me.allowDeselect) {
                  me.doDeselect(record, false);
                } else {
                  me.doSelect(record, true);
                }
                break;
              case 'SIMPLE':
                if (me.isSelected(record)) {
                  me.doDeselect(record);
                } else {
                  me.doSelect(record, true);
                }
                break;
              case 'SINGLE':
                if (me.allowDeselect && me.isSelected(record)) {
                  me.doDeselect(record);
                } else {
                  me.doSelect(record, false);
                }
                break;
              default:
                break;
            }
          }
        });
      },
      overrideViewTable: function () {
        Ext.override(Ext.view.Table, {
          getNodeByRecord: function (record, dataRow) {
            if (record) {
              var id = this.getRowId(record);
              return this.retrieveNode(id, dataRow);
            } else {
              return null;
            }
          },
          updateColumns: function (record, oldRowDom, newRowDom, columns,
              changedFieldNames) {
            var me = this,
                newAttrs, attLen, attName, attrIndex,
                colCount = columns.length,
                colIndex,
                column,
                oldCell, newCell,
                row,
                editingPlugin = me.editingPlugin || (me.lockingPartner
                    && me.ownerCt.ownerLockable.view.editingPlugin),
                isEditing = editingPlugin && editingPlugin.editing,
                cellSelector = me.getCellSelector();

            if (oldRowDom.mergeAttributes) {
              oldRowDom.mergeAttributes(newRowDom, true);
            } else {
              newAttrs = newRowDom.attributes;
              attLen = newAttrs.length;

              for (attrIndex = 0; attrIndex < attLen; attrIndex++) {
                attName = newAttrs[attrIndex].name;

                if (attName !== 'id') {
                  oldRowDom.setAttribute(attName, newAttrs[attrIndex].value);
                }
              }
            }

            for (colIndex = 0; colIndex < colCount; colIndex++) {
              column = columns[colIndex];

              if (me.shouldUpdateCell(record, column, changedFieldNames)) {
                cellSelector = me.getCellSelector(column);
                oldCell = Ext.DomQuery.selectNode(cellSelector, oldRowDom);
                newCell = Ext.DomQuery.selectNode(cellSelector, newRowDom);

                if (isEditing) {
                  try {
                    Ext.fly(oldCell).syncContent(newCell);
                  } catch (e) {

                  }
                } else {
                  row = oldCell.parentNode;
                  row.insertBefore(newCell, oldCell);
                  row.removeChild(oldCell);
                }
              }
            }
          }
        });
      },
      overrideStore: function () {
        Ext.override(Ext.data.Store, {
          getGroupsForGrouper: function (records, grouper) {
            var length = records.length,
                groups = [],
                oldValue,
                newValue,
                record,
                group,
                i;

            for (i = 0; i < length; i++) {
              record = records[i];
              newValue = grouper.getGroupString(record);

              if (this.isNewGroup(newValue, oldValue)) {
                group = {
                  name: newValue,
                  grouper: grouper,
                  records: []
                };
                groups.push(group);
              }

              group.records.push(record);

              oldValue = newValue;
            }

            return groups;
          },
          isNewGroup: function (newGroupString, oldGroupString) {
            if (Ext.isDate(newGroupString) && Ext.isDate(oldGroupString)) {
              return newGroupString.getTime() !== oldGroupString.getTime();
            } else {
              return newGroupString !== oldGroupString;
            }
          }
        });
      },
      overrideJsonWriter: function () {
        Ext.override(Ext.data.writer.Json, {
          writeRecords: function (request, data) {
            var root = this.root;

            if (this.expandData) {
              data = this.getExpandedData(data);
            }

            if (this.allowSingle && data.length === 1) {
              data = data[0];
            }

            if (this.encode) {
              if (root) {
                request.params[root] = Ext.encode(data);
              }
            } else {
              request.jsonData = request.jsonData || {};

              if (root) {
                request.jsonData[root] = data;
              } else {
                request.jsonData = data;
              }
            }

            if (request.action == 'update') {
              request.extraData = request.params;
              request.params = {};
            }

            return request;
          }
        });
      },
      overrideDataConnection: function () {
        Ext.override(Ext.data.Connection, {
          setOptions: function (options, scope) {
            var me = this,
                params = options.params || {},
                extraParams = me.extraParams,
                urlParams = options.urlParams,
                url = options.url || me.url,
                jsonData = options.jsonData,
                extraData = options.extraData,
                method,
                disableCache,
                data;

            if (Ext.isFunction(params)) {
              params = params.call(scope, options);
            }

            if (Ext.isFunction(url)) {
              url = url.call(scope, options);
            }

            url = this.setupUrl(options, url);

            data = options.rawData || options.binaryData || options.xmlData
                || jsonData || null;
            if (Ext.isObject(extraData)) {
              data = Ext.apply(data, extraData);
            }
            if (jsonData && !Ext.isPrimitive(jsonData)) {
              data = Ext.encode(data);
            }

            if (options.binaryData) {
              if (me.nativeBinaryPostSupport()) {
                data = (new Uint8Array(options.binaryData));
                if ((Ext.isChrome && Ext.chromeVersion < 22) || Ext.isSafari
                    || Ext.isGecko) {
                  data = data.buffer;
                }
              }
            }

            if (Ext.isObject(params)) {
              params = Ext.Object.toQueryString(params);
            }

            if (Ext.isObject(extraParams)) {
              extraParams = Ext.Object.toQueryString(extraParams);
            }

            params = params + ((extraParams) ? ((params) ? '&' : '')
                + extraParams : '');
            urlParams = Ext.isObject(urlParams) ? Ext.Object.toQueryString(
                urlParams) : urlParams;
            params = this.setupParams(options, params);
            method = (options.method || me.method || ((params || data) ? 'POST'
                : 'GET')).toUpperCase();
            this.setupMethod(options, method);

            disableCache = options.disableCaching !== false
                ? (options.disableCaching || me.disableCaching) : false;

            if (method === 'GET' && disableCache) {
              url = Ext.urlAppend(url,
                  (options.disableCachingParam || me.disableCachingParam)
                  + '=' + (new Date().getTime()));
            }

            if ((method == 'GET' || data) && params) {
              url = Ext.urlAppend(url, params);
              params = null;
            }

            if (urlParams) {
              url = Ext.urlAppend(url, urlParams);
            }

            return {
              url: url,
              method: method,
              data: data || params || null
            };
          }
        });
      },
      buildView: function () {
        Ext.create('Suncode.pzmodule.view.panel.MainPanel', {
          renderTo: renderTo,
          width: Ext.get(renderTo).getWidth(),
          height: Ext.getBody().getViewSize().height,
          configuration: configuration,
          documents: documents
        });
      }
    });
  };

  logPluginCloseAudit = function () {
    Ext.Ajax.request( {
      url: 'close',
      method: 'GET'
    } );
  }
})(Ext4);