( function( Ext ) {
    var messages = Suncode.context( 'pzmodule' ).messages;

    Ext.define( 'Suncode.pzmodule.view.window.ImportAttachedWindow', {
        extend: 'Ext.window.Window',
        alias: 'widget.importattachedwindow',
        title: messages( 'pzmodule.importfromexcel' ),
        modal: true,
        items: [ {
            xtype: 'form',
            frame: false,
            border: 0,
            buttonAlign: 'center',
            items: [ {
                xtype: 'fileuploadfield',
                allowBlank: false,
                buttonText: '',
                fieldLabel: messages( 'pzmodule.excelfile' ),
                labelSeparator: '',
                msgTarget: 'side',
                name: 'file',
                regex: new RegExp( '.xlsx$|.xls$', 'i' ),
                regexText: messages( 'pzmodule.noexcel' ),
                width: 550
            }, {
            	xtype: 'checkbox',
                name: 'overrideData',
                fieldLabel: messages( 'pzmodule.overridedata' ),
                labelSeparator: '',
            } ],
            buttons: [ {
                itemId: 'importAttachedButton',
                text: messages( 'pzmodule.import' ),
                iconCls: 'dvnt-icon-upload'
            }, {
                itemId: 'downloadTemplateButton',
                text: messages( 'pzmodule.downloadtemplate' ),
                iconCls: 'dvnt-icon-download'
            }, {
                itemId: 'closeWindowButton',
                text: messages( 'pzmodule.cancel' ),
                iconCls: 'dvnt-icon-x-symbol'
            } ]
        } ],
        initComponent: function() {
            this.callParent( arguments );
        }
    } );
}( this.Ext4 ) );