( function( Ext ) {
    var messages = Suncode.context( 'pzmodule' ).messages;

    Ext.define( 'Suncode.pzmodule.view.table.ConfigurationTable', {
        extend: 'Ext.grid.Panel',
        alias: 'widget.configurationtable',
        requires: [ 'Suncode.pzmodule.view.window.ManageConfigurationWindow', 'Suncode.pzmodule.view.window.ImportAttachedWindow' ],
        title: messages( 'pzmodule.configurations' ),
        titleAlign: 'center',
        frame: true,
        columnLines: true,
        viewConfig: {
            enableTextSelection: true,
            emptyText: messages( 'pzmodule.noconfigurations' )
        },
        selModel: {
            model: 'SIMPLE'
        },
        tbar: {
            items: [ {
                xtype: 'button',
                itemId: 'addConfigurationButton',
                text: messages( 'pzmodule.add' ),
                iconCls: 'dvnt-icon-plus-circle'
            }, {
                xtype: 'button',
                itemId: 'editConfigurationButton',
                text: messages( 'pzmodule.edit' ),
                iconCls: 'dvnt-icon-edit'
            }, {
                xtype: 'button',
                itemId: 'deleteConfigurationButton',
                text: messages( 'pzmodule.delete' ),
                iconCls: 'dvnt-icon-minus-circle'
            }, {
                xtype: 'button',
                itemId: 'downloadConfigurationButton',
                text: messages( 'pzmodule.download' ),
                iconCls: 'dvnt-icon-download'
            }, {
            	xtype: 'tbseparator'
            }, {
                xtype: 'button',
                itemId: 'importAttachedButton',
                text: messages( 'pzmodule.importattached' ),
                iconCls: 'dvnt-icon-upload'
            } ]
        },
        columns: [ {
            xtype: 'rownumberer'
        }, {
            dataIndex: 'id',
            hidden: true,
            hideable: false
        }, {
            dataIndex: 'configurationId',
            text: messages( 'pzmodule.id' ),
            menuDisabled: true,
            width: 200
        }, {
            dataIndex: 'name',
            text: messages( 'pzmodule.name' ),
            menuDisabled: true,
            width: 200
        }, {
            dataIndex: 'description',
            text: messages( 'pzmodule.description' ),
            menuDisabled: true,
            flex: 1,
            tdCls: 'pzmodule-text-wrap'
        } ],
        initComponent: function() {
            var store = this.buildStore();
            this.store = store;

            this.callParent( arguments );
        },
        buildStore: function() {
            return Ext.create( 'Ext.data.Store', {
                autoLoad: true,
                fields: [ {
                    name: 'id',
                    type: 'int'
                }, {
                    name: 'configurationId',
                    type: 'string'
                }, {
                    name: 'name',
                    type: 'string'
                }, {
                    name: 'description',
                    type: 'string'
                } ],
                proxy: {
                    type: 'rest',
                    api: {
                        read: Suncode.context( 'pzmodule' ).pluginContextPath + '/api/administration/configuration/read',
                        destroy: Suncode.context( 'pzmodule' ).pluginContextPath + '/api/administration/configuration/delete'
                    },
                    timeout: 900000,
                    noCache: false,
                    pageParam: undefined,
                    startParam: undefined,
                    limitParam: undefined
                },
                sorters: [ {
                	property: 'name'
                } ]
            } );
        },
        reload: function() {
            var store = this.getStore();
            store.reload();
        }
    } );
}( this.Ext4 ) );