( function( Ext ) {
	var messages = Suncode.context( 'pzmodule' ).messages;
	
    Ext.define( 'Suncode.pzmodule.controller.window.ManageConfigurationWindowController', {
        extend: 'Ext.app.Controller',
        init: function() {
            this.control( {
            	'manageconfigurationwindow': {
            		afterrender: this.onAfterRender
                },
                'manageconfigurationwindow checkbox[name=useFile]': {
                	change: this.onUseFileChange
                }
            } );
        },
        onAfterRender: function( win, eOpts ) {
        	var idOfConfiguration = win.idOfConfiguration;
        	
        	if ( !Ext.isEmpty( idOfConfiguration ) ) {
        		var form = win.down( 'form' ).getForm();
            	form.load( {
            		url: Suncode.context( 'pzmodule' ).pluginContextPath + '/api/administration/configuration/get/' + idOfConfiguration,
            		method: 'GET',
            		timeout: 120,
            		failure: function( form, action ) {
                        var errorMessage = !Ext.isEmpty( action.result ) ? action.result.message : '';

                        Ext.Msg.show( {
                            title: messages( 'pzmodule.error' ),
                            msg: !Ext.isEmpty( errorMessage ) ? errorMessage : messages( 'pzmodule.loadconfigurationerror' ),
                            buttons: Ext.Msg.OK,
                            icon: 'dvnt-icon-x-circle dvnt-red-icon'
                        } );
                    }
            	} );
        	}
        },
        onUseFileChange: function( field, newValue, oldValue, eOpts ) {
        	var form = field.up( 'form' ).getForm();
        	var fileField = form.findField( 'file' );
        	Ext.apply( fileField, {
        		allowBlank: !newValue
        	} );
        	
        	if ( newValue ) {
        		fileField.show();
        	} else {
        		fileField.hide();
        	}
        	
        	fileField.clearInvalid();
        }
    } );
}( this.Ext4 ) );