/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.support.dto.settings.builder;

import com.suncode.plugin.pzmodule.api.dto.settings.GroupingSettingsDto;
import com.suncode.plugin.pzmodule.api.dto.settings.SettingsDto;
import com.suncode.plugin.pzmodule.api.dto.settings.SortingSettingsDto;
import com.suncode.plugin.pzmodule.model.settings.Settings;
import com.suncode.plugin.pzmodule.web.support.dto.settings.builder.GroupingSettingsDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.settings.builder.SettingsDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.settings.builder.SortingSettingsDtoBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SettingsDtoBuilderImpl
implements SettingsDtoBuilder {
    @Autowired
    private GroupingSettingsDtoBuilder groupingSettingsDtoBuilder;
    @Autowired
    private SortingSettingsDtoBuilder sortingSettingsDtoBuilder;

    @Override
    public List<SettingsDto> buildBasic(List<Settings> entities) {
        ArrayList<SettingsDto> dtos = new ArrayList<SettingsDto>();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (Settings entity : entities) {
                dtos.add(this.buildBasic(entity));
            }
        }
        return dtos;
    }

    @Override
    public SettingsDto buildBasic(Settings entity) {
        SettingsDto dto = new SettingsDto();
        dto.setId(entity.getId());
        dto.setName(entity.getName());
        dto.setOwnerId(entity.getOwnerId());
        dto.setIsDefault(entity.getIsDefault());
        dto.setShared(entity.getShared());
        return dto;
    }

    @Override
    public List<SettingsDto> build(List<Settings> entities) {
        ArrayList<SettingsDto> dtos = new ArrayList<SettingsDto>();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (Settings entity : entities) {
                dtos.add(this.build(entity));
            }
        }
        return dtos;
    }

    @Override
    public SettingsDto build(Settings entity) {
        SettingsDto dto = new SettingsDto();
        dto.setId(entity.getId());
        dto.setAttached(entity.getAttached());
        dto.setOwnerId(entity.getOwnerId());
        dto.setConfigurationId(entity.getConfigurationId());
        dto.setName(entity.getName());
        dto.setIsDefault(entity.getIsDefault());
        dto.setShared(entity.getShared());
        dto.setGroupingSettings(this.buildGroupingSettings(entity));
        dto.setSortingSettings(this.buildSortingSettings(entity));
        return dto;
    }

    private GroupingSettingsDto buildGroupingSettings(Settings entity) {
        return this.groupingSettingsDtoBuilder.build(entity.getGroupingSettings());
    }

    private SortingSettingsDto buildSortingSettings(Settings entity) {
        return this.sortingSettingsDtoBuilder.build(entity.getSortingSettings());
    }
}

