/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.support.dto.configuration.supplier;

import com.suncode.plugin.pzmodule.api.dto.configuration.FilterInitDto;
import com.suncode.plugin.pzmodule.api.enumeration.FilterInitType;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.supplier.FilterInitSupplier;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class FilterInitSupplierImpl
implements FilterInitSupplier {
    private static final Logger LOG = Logger.getLogger(FilterInitSupplierImpl.class);

    @Override
    public void supply(FilterInitDto dto, Map<String, Object> activityContext, Map<String, Object> extraParameters) {
        if (dto != null && StringUtils.isNotBlank((CharSequence)dto.getType())) {
            switch (FilterInitType.getByName(dto.getType())) {
                case FIXED: {
                    dto.setInitValue(dto.getValue());
                    break;
                }
                case VARIABLE: {
                    dto.setInitValue(this.resolveVariableValue(dto, activityContext, extraParameters));
                    break;
                }
                default: {
                    LOG.error((Object)("Nieznany typ inicjacji filtru " + dto.getType()));
                }
            }
        }
    }

    private String resolveVariableValue(FilterInitDto dto, Map<String, Object> activityContext, Map<String, Object> extraParameters) {
        String id = dto.getValue();
        Object variableValue = this.resolveVariableValue(id, activityContext, extraParameters);
        return variableValue != null ? variableValue.toString() : "";
    }

    private Object resolveVariableValue(String id, Map<String, Object> activityContext, Map<String, Object> extraParameters) {
        if (activityContext.containsKey(id)) {
            return activityContext.get(id);
        }
        return extraParameters.get(id);
    }
}

