/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.support.dto.configuration.builder;

import com.suncode.plugin.pzmodule.api.dto.configuration.ButtonDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ColumnDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ExternalJavaScriptFileDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.FilterRelationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.GroupingConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.JavaScriptActionsDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PanelsConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PartialAttachmentConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SearchDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SorterDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ToolbarFieldDto;
import com.suncode.plugin.pzmodule.api.enumeration.ButtonLocation;
import com.suncode.plugin.pzmodule.model.configuration.Button;
import com.suncode.plugin.pzmodule.model.configuration.Column;
import com.suncode.plugin.pzmodule.model.configuration.Configuration;
import com.suncode.plugin.pzmodule.model.configuration.Sorter;
import com.suncode.plugin.pzmodule.model.configuration.ToolbarField;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.ButtonDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.ColumnDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.ConfigurationDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.ExternalJavaScriptFileDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.FilterRelationDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.GroupingConfigurationDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.JavaScriptActionsDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.PanelsConfigurationDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.PartialAttachmentConfigurationDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.SaveDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.SearchDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.SorterDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.ToolbarFieldDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.supplier.ConfigurationDtoSupplier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationDtoBuilderImpl
implements ConfigurationDtoBuilder {
    private static final String ATTACHED_COLUMN_ID_PREFIX = "attached_";
    private static final String NOT_ATTACHED_COLUMN_ID_PREFIX = "not_attached_";
    private static final String EDITABLE_COLUMN_BACKGROUND_COLOR_DEFAULT_VALUE = "rgba(255, 255, 153, 0.3)";
    @Autowired
    private ExternalJavaScriptFileDtoBuilder externalJavaScriptFileDtoBuilder;
    @Autowired
    private JavaScriptActionsDtoBuilder javaScriptActionsDtoBuilder;
    @Autowired
    private PanelsConfigurationDtoBuilder panelsConfigurationDtoBuilder;
    @Autowired
    private SearchDtoBuilder searchDtoBuilder;
    @Autowired
    private ColumnDtoBuilder columnDtoBuilder;
    @Autowired
    private GroupingConfigurationDtoBuilder groupingConfigurationDtoBuilder;
    @Autowired
    private PartialAttachmentConfigurationDtoBuilder partialAttachmentConfigurationDtoBuilder;
    @Autowired
    private SorterDtoBuilder sorterDtoBuilder;
    @Autowired
    private SaveDtoBuilder saveDtoBuilder;
    @Autowired
    private ButtonDtoBuilder buttonDtoBuilder;
    @Autowired
    private ToolbarFieldDtoBuilder toolbarFieldDtoBuilder;
    @Autowired
    private FilterRelationDtoBuilder filterRelationDtoBuilder;
    @Autowired
    private ConfigurationDtoSupplier configurationDtoSupplier;

    @Override
    public List<ConfigurationDto> buildBasic(List<Configuration> entities) {
        ArrayList<ConfigurationDto> dtos = new ArrayList<ConfigurationDto>();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (Configuration entity : entities) {
                dtos.add(this.buildBasic(entity));
            }
        }
        return dtos;
    }

    @Override
    public ConfigurationDto buildBasic(Configuration entity) {
        ConfigurationDto dto = new ConfigurationDto();
        dto.setId(entity.getId());
        dto.setConfigurationId(entity.getConfigurationId());
        dto.setName(entity.getName());
        dto.setDescription(entity.getDescription());
        return dto;
    }

    @Override
    public List<ConfigurationDto> build(List<Configuration> entities) {
        ArrayList<ConfigurationDto> dtos = new ArrayList<ConfigurationDto>();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (Configuration entity : entities) {
                dtos.add(this.build(entity));
            }
        }
        return dtos;
    }

    @Override
    public ConfigurationDto build(Configuration entity) {
        ArrayList<ButtonDto> attachedPanelButtons = new ArrayList<ButtonDto>();
        ArrayList<ButtonDto> notAttachedPanelButtons = new ArrayList<ButtonDto>();
        ArrayList<ButtonDto> rightPanelButtons = new ArrayList<ButtonDto>();
        ArrayList<ToolbarFieldDto> attachedPanelToolbarFields = new ArrayList<ToolbarFieldDto>();
        ArrayList<ToolbarFieldDto> notAttachedPanelToolbarFields = new ArrayList<ToolbarFieldDto>();
        String decimalSeparator = this.buildDecimalSeparator(entity);
        ConfigurationDto dto = this.buildBasic(entity);
        dto.setExternalJavaScriptFiles(this.builExternalJavaScriptFiles(entity));
        dto.setNewWindowDocumentPreview(entity.getNewWindowDocumentPreview());
        dto.setAttachmentWindow(entity.getAttachmentWindow());
        dto.setDecimalSeparator(decimalSeparator);
        dto.setLiveFiltering(entity.getLiveFiltering());
        dto.setEnableDuplicateChoice(entity.getEnableDuplicateChoice());
        dto.setJavaScriptActions(this.buildJavaScriptActions(entity));
        dto.setPanelsConfiguration(this.buildPanelsConfiguration(entity));
        dto.setSearch(this.buildSearch(entity));
        dto.setTableFontSize(entity.getTableFontSize());
        dto.setEditableColumnBackgroundColor(this.buildEditableColumnBackgroundColor(entity.getEditableColumnBackgroundColor(), EDITABLE_COLUMN_BACKGROUND_COLOR_DEFAULT_VALUE));
        dto.setAttachedColumns(this.buildAttachedColumns(entity, decimalSeparator));
        dto.setNotAttachedColumns(this.buildNotAttachedColumns(entity, decimalSeparator));
        dto.setGroupingConfiguration(this.buildGroupingConfiguration(entity));
        dto.setPartialAttachmentConfiguration(this.buildPartialAttachmentConfiguration(entity));
        dto.setAttachedSorters(this.buildAttachedSorters(entity));
        dto.setNotAttachedSorters(this.buildNotAttachedSorters(entity));
        dto.setFilterRelations(this.buildFilterRelations(entity));
        dto.setSave(this.buildSave(entity));
        if (CollectionUtils.isNotEmpty(entity.getButtons())) {
            for (Button button : entity.getButtons()) {
                switch (ButtonLocation.getByName(button.getLocation())) {
                    case ATTACHED_PANEL: {
                        attachedPanelButtons.add(this.buildButton(button));
                        break;
                    }
                    case NOT_ATTACHED_PANEL: {
                        notAttachedPanelButtons.add(this.buildButton(button));
                        break;
                    }
                    case RIGHT_PANEL: {
                        rightPanelButtons.add(this.buildButton(button));
                        break;
                    }
                }
            }
        }
        dto.setAttachedPanelButtons(attachedPanelButtons);
        dto.setNotAttachedPanelButtons(notAttachedPanelButtons);
        dto.setRightPanelButtons(rightPanelButtons);
        if (CollectionUtils.isNotEmpty(entity.getToolbarFields())) {
            for (ToolbarField toolbarField : entity.getToolbarFields()) {
                switch (ButtonLocation.getByName(toolbarField.getLocation())) {
                    case ATTACHED_PANEL: {
                        attachedPanelToolbarFields.add(this.buildToolbarField(toolbarField));
                        break;
                    }
                    case NOT_ATTACHED_PANEL: {
                        notAttachedPanelToolbarFields.add(this.buildToolbarField(toolbarField));
                        break;
                    }
                }
            }
        }
        dto.setAttachedPanelToolbarFields(attachedPanelToolbarFields);
        dto.setNotAttachedPanelToolbarFields(notAttachedPanelToolbarFields);
        return this.supply(dto);
    }

    private List<ExternalJavaScriptFileDto> builExternalJavaScriptFiles(Configuration entity) {
        return this.externalJavaScriptFileDtoBuilder.build(entity.getExternalJavaScriptFiles());
    }

    private String buildDecimalSeparator(Configuration entity) {
        return (String)StringUtils.defaultIfBlank((CharSequence)entity.getDecimalSeparator(), (CharSequence)",");
    }

    private JavaScriptActionsDto buildJavaScriptActions(Configuration entity) {
        return this.javaScriptActionsDtoBuilder.build(entity.getJavaScriptActions());
    }

    private PanelsConfigurationDto buildPanelsConfiguration(Configuration entity) {
        return this.panelsConfigurationDtoBuilder.build(entity.getPanelsConfiguration());
    }

    private SearchDto buildSearch(Configuration entity) {
        return this.searchDtoBuilder.build(entity.getSearch());
    }

    private String buildEditableColumnBackgroundColor(String color, String defaultColor) {
        return (String)StringUtils.defaultIfBlank((CharSequence)color, (CharSequence)defaultColor);
    }

    private List<ColumnDto> buildAttachedColumns(Configuration entity, String decimalSeparator) {
        return this.buildColumns(entity.getAttachedColumns(), ATTACHED_COLUMN_ID_PREFIX, decimalSeparator);
    }

    private List<ColumnDto> buildNotAttachedColumns(Configuration entity, String decimalSeparator) {
        return this.buildColumns(entity.getNotAttachedColumns(), NOT_ATTACHED_COLUMN_ID_PREFIX, decimalSeparator);
    }

    private List<ColumnDto> buildColumns(List<Column> entities, String idPrefix, String decimalSeparator) {
        return this.columnDtoBuilder.build(entities, idPrefix, decimalSeparator);
    }

    private GroupingConfigurationDto buildGroupingConfiguration(Configuration entity) {
        return this.groupingConfigurationDtoBuilder.build(entity.getGroupingConfiguration());
    }

    private PartialAttachmentConfigurationDto buildPartialAttachmentConfiguration(Configuration entity) {
        return this.partialAttachmentConfigurationDtoBuilder.build(entity.getPartialAttachmentConfiguration());
    }

    private List<SorterDto> buildAttachedSorters(Configuration entity) {
        return this.buildSorters(entity.getAttachedSorters());
    }

    private List<SorterDto> buildNotAttachedSorters(Configuration entity) {
        return this.buildSorters(entity.getNotAttachedSorters());
    }

    private List<SorterDto> buildSorters(List<Sorter> entities) {
        return this.sorterDtoBuilder.build(entities);
    }

    private SaveDto buildSave(Configuration entity) {
        return this.saveDtoBuilder.build(entity.getSave());
    }

    private ButtonDto buildButton(Button entity) {
        return this.buttonDtoBuilder.build(entity);
    }

    private ToolbarFieldDto buildToolbarField(ToolbarField entity) {
        return this.toolbarFieldDtoBuilder.build(entity);
    }

    private List<FilterRelationDto> buildFilterRelations(Configuration entity) {
        return this.filterRelationDtoBuilder.build(entity.getFilterRelations());
    }

    private ConfigurationDto supply(ConfigurationDto dto) {
        return this.configurationDtoSupplier.supply(dto);
    }
}

