/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.support.dto.configuration.builder;

import com.suncode.plugin.pzmodule.api.constant.Defaults;
import com.suncode.plugin.pzmodule.api.dto.configuration.ColumnDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.EditorDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.FiltersInitDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnAlignment;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.enumeration.FieldType;
import com.suncode.plugin.pzmodule.api.enumeration.FilterType;
import com.suncode.plugin.pzmodule.model.configuration.Column;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.ColumnDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.EditorDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.FiltersInitDtoBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ColumnDtoBuilderImpl
implements ColumnDtoBuilder {
    private static final String STATE_ID_POSTFIX = "_state_id";
    private static final Integer EDITABLE_COLUMN_MIN_WIDTH = 100;
    @Autowired
    private FiltersInitDtoBuilder filtersInitDtoBuilder;
    @Autowired
    @Qualifier(value="textEditorDtoBuilder")
    private EditorDtoBuilder textEditorDtoBuilder;
    @Autowired
    @Qualifier(value="intEditorDtoBuilder")
    private EditorDtoBuilder intEditorDtoBuilder;
    @Autowired
    @Qualifier(value="floatEditorDtoBuilder")
    private EditorDtoBuilder floatEditorDtoBuilder;
    @Autowired
    @Qualifier(value="dateEditorDtoBuilder")
    private EditorDtoBuilder dateEditorDtoBuilder;

    @Override
    public List<ColumnDto> build(List<Column> entities, String idPrefix, String decimalSeparator) {
        ArrayList<ColumnDto> dtos = new ArrayList<ColumnDto>();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (Column entity : entities) {
                ColumnDto dto = this.build(entity, idPrefix, decimalSeparator);
                if (dtos.contains(dto)) continue;
                dtos.add(dto);
            }
        }
        return dtos;
    }

    @Override
    public ColumnDto build(Column entity, String idPrefix, String decimalSeparator) {
        String id = this.buildId(entity, idPrefix);
        ColumnDto dto = new ColumnDto();
        dto.setId(id);
        dto.setStateId(this.buildStateId(id));
        dto.setText(entity.getName());
        dto.setDataIndex(entity.getColumnId());
        dto.setInputDateFormat(entity.getInputFormat());
        dto.setEditable(entity.getEditable());
        dto.setFilterable(this.buildFilterable(entity));
        dto.setHidden(entity.getHidden());
        dto.setWrapText(entity.getWordWrap());
        dto.setCellTooltip(entity.getCellTooltip());
        dto.setWidth(this.buildWidth(entity));
        dto.setFiltersInit(this.buildFiltersInit(entity));
        dto.setExpression(entity.getExpression());
        switch (ColumnType.getByName(entity.getType())) {
            case INT: {
                dto.setColumnType(ColumnType.INT.getName());
                dto.setFieldType(FieldType.INT.getName());
                dto.setFilterType(FilterType.INT.getName());
                dto.setAlign(this.buildAlign(entity, ColumnAlignment.RIGHT));
                dto.setEditor(this.buildEditor(dto, this.intEditorDtoBuilder));
                break;
            }
            case FLOAT: {
                dto.setColumnType(ColumnType.FLOAT.getName());
                dto.setFieldType(FieldType.FLOAT.getName());
                dto.setIsFloatColumn(true);
                dto.setDecimalPrecision(this.buildDecimalPrecision(entity));
                dto.setDecimalSeparator(decimalSeparator);
                dto.setFilterType(FilterType.FLOAT.getName());
                dto.setAlign(this.buildAlign(entity, ColumnAlignment.RIGHT));
                dto.setEditor(this.buildEditor(dto, this.floatEditorDtoBuilder));
                break;
            }
            case DATE: {
                dto.setColumnType(ColumnType.DATE.getName());
                dto.setFieldType(FieldType.DATE.getName());
                dto.setIsDateColumn(true);
                dto.setDateFormat(this.buildDateFormat(entity));
                dto.setFilterType(FilterType.DATE.getName());
                dto.setAlign(this.buildAlign(entity, ColumnAlignment.CENTER));
                dto.setEditor(this.buildEditor(dto, this.dateEditorDtoBuilder));
                break;
            }
            case DATE_STRING: {
                dto.setColumnType(ColumnType.DATE_STRING.getName());
                dto.setFieldType(FieldType.DATE.getName());
                dto.setIsDateColumn(true);
                dto.setDateFormat(this.buildDateFormat(entity));
                dto.setFilterType(FilterType.DATE.getName());
                dto.setAlign(this.buildAlign(entity, ColumnAlignment.CENTER));
                dto.setEditor(this.buildEditor(dto, this.dateEditorDtoBuilder));
                break;
            }
            default: {
                dto.setColumnType(ColumnType.STRING.getName());
                dto.setFieldType(FieldType.STRING.getName());
                dto.setFilterType(FilterType.STRING.getName());
                dto.setAlign(this.buildAlign(entity, ColumnAlignment.LEFT));
                dto.setEditor(this.buildEditor(dto, this.textEditorDtoBuilder));
            }
        }
        if (dto.getEditor() != null) {
            dto.setMinWidth(EDITABLE_COLUMN_MIN_WIDTH);
        }
        return dto;
    }

    private String buildId(Column entity, String idPrefix) {
        StringBuilder id = new StringBuilder();
        id.append(idPrefix);
        id.append(entity.getColumnId().toLowerCase().replaceAll("[^a-z0-9]+", ""));
        return id.toString();
    }

    private String buildStateId(String id) {
        StringBuilder stateId = new StringBuilder();
        stateId.append(id);
        stateId.append(STATE_ID_POSTFIX);
        return stateId.toString();
    }

    private FiltersInitDto buildFiltersInit(Column entity) {
        return this.filtersInitDtoBuilder.build(entity.getFiltersInit());
    }

    private String buildAlign(Column entity, ColumnAlignment defaultAlignment) {
        return entity.getAlign() != null ? entity.getAlign() : defaultAlignment.getName();
    }

    private EditorDto buildEditor(ColumnDto dto, EditorDtoBuilder editorDtoBuilder) {
        if (this.shouldBuildEditor(dto)) {
            return editorDtoBuilder.build(dto);
        }
        return null;
    }

    private boolean shouldBuildEditor(ColumnDto dto) {
        return BooleanUtils.isTrue((Boolean)dto.getEditable());
    }

    private Integer buildDecimalPrecision(Column entity) {
        try {
            return Integer.parseInt(entity.getFormat());
        }
        catch (NumberFormatException exception) {
            return Defaults.COLUMN_DECIMAL_PRECISION;
        }
    }

    private String buildDateFormat(Column entity) {
        return StringUtils.isNotBlank((CharSequence)entity.getFormat()) ? entity.getFormat() : "Y-m-d";
    }

    private Boolean buildFilterable(Column entity) {
        return StringUtils.isBlank((CharSequence)entity.getExpression()) && BooleanUtils.isTrue((Boolean)entity.getFilterable());
    }

    private Integer buildWidth(Column entity) {
        return this.hasWidth(entity) ? entity.getWidth() : null;
    }

    private boolean hasWidth(Column entity) {
        return entity.getWidth() != null && entity.getWidth() > 0;
    }
}

