/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.validator;

import com.suncode.plugin.pzmodule.api.dto.configuration.ColumnDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.api.util.QueryUtils;
import com.suncode.plugin.pzmodule.exception.SaveValidationException;
import com.suncode.plugin.pzmodule.object.Used;
import com.suncode.plugin.pzmodule.object.ValidationError;
import com.suncode.plugin.pzmodule.resolver.parentvalue.ParentValueResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.ColumnTypesResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.QueryResolver;
import com.suncode.plugin.pzmodule.resolver.validator.UsedResolver;
import com.suncode.plugin.pzmodule.validator.SaveValidator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.AbstractStandardBasicType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="usedValidator")
public class UsedValidatorImpl
implements SaveValidator {
    private static final Logger LOG = Logger.getLogger(UsedValidatorImpl.class);
    private static final String OR_JOINER = " OR ";
    @Autowired
    private ColumnTypesResolver columnTypesResolver;
    @Autowired
    private ParentValueResolver parentValueResolver;
    @Autowired
    private QueryResolver queryResolver;
    @Autowired
    private UsedResolver usedResolver;

    @Override
    public List<ValidationError> validate(ConfigurationDto configuration, SaveInfo saveInfo, List<Record> attachedRecords) throws SaveValidationException {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        List<Used> usedList = this.getUsed(configuration, saveInfo, attachedRecords);
        if (CollectionUtils.isNotEmpty(usedList)) {
            for (Used used : usedList) {
                errors.add(this.buildValidationError(used));
            }
        }
        return errors;
    }

    private List<Used> getUsed(ConfigurationDto configuration, SaveInfo saveInfo, List<Record> attachedRecords) throws SaveValidationException {
        ColumnType primaryKeyColumnType = this.getPrimaryKeyColumnType(configuration);
        String validateUsedQuery = this.buildValidateUsedQuery(configuration, saveInfo, primaryKeyColumnType, attachedRecords);
        Map<String, AbstractStandardBasicType<?>> scalars = this.buildScalars(primaryKeyColumnType);
        LOG.info((Object)("Zapytanie dla walidacji uzytych: " + validateUsedQuery));
        return this.usedResolver.resolve(validateUsedQuery, scalars);
    }

    private ColumnType getPrimaryKeyColumnType(ConfigurationDto configuration) {
        List<ColumnDto> columns = configuration.getAttachedColumns();
        Map<String, ColumnType> columnTypes = this.columnTypesResolver.resolve(columns);
        String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
        return columnTypes.get(primaryKeyName);
    }

    private String buildValidateUsedQuery(ConfigurationDto configuration, SaveInfo saveInfo, ColumnType primaryKeyColumnType, List<Record> attachedRecords) {
        List<String> selects = this.buildSelects(primaryKeyColumnType);
        List<String> conditions = this.buildConditions(configuration, saveInfo, primaryKeyColumnType, attachedRecords);
        return this.queryResolver.resolveValidateQuery(selects, "pm_pzmodule_partial_att", conditions);
    }

    private List<String> buildSelects(ColumnType primaryKeyColumnType) {
        ArrayList<String> selects = new ArrayList<String>();
        selects.add(primaryKeyColumnType.getPartialAttachmentValueColumn());
        return selects;
    }

    private List<String> buildConditions(ConfigurationDto configuration, SaveInfo saveInfo, ColumnType primaryKeyColumnType, List<Record> attachedRecords) {
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add(this.buildConfigurationIdCondition(configuration, saveInfo));
        conditions.add(this.buildProcessIdCondition(configuration, saveInfo));
        conditions.add(this.buildRecordsCondition(configuration, primaryKeyColumnType, attachedRecords));
        return conditions;
    }

    private String buildConfigurationIdCondition(ConfigurationDto configuration, SaveInfo saveInfo) {
        StringBuilder condition = new StringBuilder();
        condition.append("configuration_id='");
        condition.append(this.parentValueResolver.resolveConfigurationId(configuration, saveInfo.getParentValues()));
        condition.append("'");
        return condition.toString();
    }

    private String buildProcessIdCondition(ConfigurationDto configuration, SaveInfo saveInfo) {
        StringBuilder condition = new StringBuilder();
        condition.append("process_id!='");
        condition.append(this.parentValueResolver.resolveProcessId(configuration, saveInfo.getProcessId(), saveInfo.getParentValues()));
        condition.append("'");
        return condition.toString();
    }

    private String buildRecordsCondition(ConfigurationDto configuration, ColumnType primaryKeyColumnType, List<Record> attachedRecords) {
        List<String> subConditions = this.buildRecordsSubConditions(configuration, primaryKeyColumnType, attachedRecords);
        StringBuilder condition = new StringBuilder();
        condition.append("(");
        condition.append(StringUtils.join(subConditions, (String)OR_JOINER));
        condition.append(")");
        return condition.toString();
    }

    private List<String> buildRecordsSubConditions(ConfigurationDto configuration, ColumnType primaryKeyColumnType, List<Record> attachedRecords) {
        ArrayList<String> subConditions = new ArrayList<String>();
        for (Record record : attachedRecords) {
            subConditions.add(this.buildRecordSubCondition(configuration, primaryKeyColumnType, record));
        }
        return subConditions;
    }

    private String buildRecordSubCondition(ConfigurationDto configuration, ColumnType primaryKeyColumnType, Record record) {
        String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
        String primaryKeyValue = record.getValue(primaryKeyName);
        StringBuilder condition = new StringBuilder();
        condition.append(primaryKeyColumnType.getPartialAttachmentValueColumn());
        condition.append("=");
        condition.append(primaryKeyColumnType.getConditionSuffix());
        condition.append(QueryUtils.getSafeValue(primaryKeyValue));
        condition.append(primaryKeyColumnType.getConditionSuffix());
        return condition.toString();
    }

    private Map<String, AbstractStandardBasicType<?>> buildScalars(ColumnType primaryKeyColumnType) {
        LinkedHashMap scalars = new LinkedHashMap();
        scalars.put(primaryKeyColumnType.getPartialAttachmentValueColumn(), primaryKeyColumnType.getScalar());
        return scalars;
    }

    private ValidationError buildValidationError(Used used) {
        ValidationError error = new ValidationError();
        error.setPrimaryKeyValue(used.getPrimaryKeyValue());
        return error;
    }
}

