/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.validator;

import com.suncode.plugin.pzmodule.api.dto.configuration.ColumnDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PrimaryKeyDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SearchLocationDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.enumeration.PrimaryKeyType;
import com.suncode.plugin.pzmodule.api.enumeration.RecordLocation;
import com.suncode.plugin.pzmodule.api.exception.RecordProviderException;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.api.util.MathUtils;
import com.suncode.plugin.pzmodule.api.util.QueryUtils;
import com.suncode.plugin.pzmodule.exception.SaveValidationException;
import com.suncode.plugin.pzmodule.object.AttachedAmount;
import com.suncode.plugin.pzmodule.object.RemainingAmount;
import com.suncode.plugin.pzmodule.object.ValidationError;
import com.suncode.plugin.pzmodule.object.builder.AttachedAmountBuilder;
import com.suncode.plugin.pzmodule.resolver.recordprovider.ColumnTranslationResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.ColumnTypesResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.DocumentClassResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.PartialAttachmentSubqueryResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.QueryResolver;
import com.suncode.plugin.pzmodule.resolver.validator.RemainingAmountResolver;
import com.suncode.plugin.pzmodule.validator.SaveValidator;
import com.suncode.pwfl.archive.DocumentClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="partialAttachmentAmountValidator")
public class PartialAttachmentAmountValidatorImpl
implements SaveValidator {
    private static final Logger LOG = Logger.getLogger(PartialAttachmentAmountValidatorImpl.class);
    private static final String ZERO = "0";
    private static final String OR_JOINER = " OR ";
    @Autowired
    private AttachedAmountBuilder attachedAmountBuilder;
    @Autowired
    private ColumnTypesResolver columnTypesResolver;
    @Autowired
    private ColumnTranslationResolver columnTranslationResolver;
    @Autowired
    private PartialAttachmentSubqueryResolver partialAttachmentSubqueryResolver;
    @Autowired
    private DocumentClassResolver documentClassResolver;
    @Autowired
    private QueryResolver queryResolver;
    @Autowired
    private RemainingAmountResolver remainingAmountResolver;

    @Override
    public List<ValidationError> validate(ConfigurationDto configuration, SaveInfo saveInfo, List<Record> attachedRecords) throws SaveValidationException {
        Map<String, AttachedAmount> attachedAmounts = this.getAttachedAmounts(configuration, saveInfo.getInitiallyAttachedRecords(), attachedRecords);
        List<RemainingAmount> remainingAmounts = this.getRemainingAmounts(configuration, saveInfo, attachedRecords);
        return this.validate(configuration, attachedAmounts, remainingAmounts);
    }

    private Map<String, AttachedAmount> getAttachedAmounts(ConfigurationDto configuration, List<Record> initiallyAttachedRecords, List<Record> attachedRecords) {
        String stringAmount;
        String primaryKeyValue;
        HashMap<String, AttachedAmount> attachedAmounts = new HashMap<String, AttachedAmount>();
        String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
        String amountColumnId = configuration.getPartialAttachmentConfiguration().getAmountColumnId();
        for (Record record : attachedRecords) {
            primaryKeyValue = (String)record.get(primaryKeyName);
            stringAmount = (String)StringUtils.defaultIfBlank((CharSequence)record.getValue(amountColumnId), (CharSequence)ZERO);
            Double amount = Double.valueOf(stringAmount);
            attachedAmounts.put(primaryKeyValue, this.buildAttachedAmount(amount));
        }
        if (CollectionUtils.isNotEmpty(initiallyAttachedRecords)) {
            for (Record record : initiallyAttachedRecords) {
                primaryKeyValue = (String)record.get(primaryKeyName);
                if (!attachedAmounts.containsKey(primaryKeyValue)) continue;
                stringAmount = (String)StringUtils.defaultIfBlank((CharSequence)record.getValue(amountColumnId), (CharSequence)ZERO);
                Double initialAmount = Double.valueOf(stringAmount);
                AttachedAmount attachedAmount = (AttachedAmount)attachedAmounts.get(primaryKeyValue);
                attachedAmount.setDifference(MathUtils.subtract(attachedAmount.getAmount(), initialAmount));
                attachedAmounts.put(primaryKeyValue, attachedAmount);
            }
        }
        return attachedAmounts;
    }

    private AttachedAmount buildAttachedAmount(Double amount) {
        return this.attachedAmountBuilder.build(amount);
    }

    private List<RemainingAmount> getRemainingAmounts(ConfigurationDto configuration, SaveInfo saveInfo, List<Record> attachedRecords) throws SaveValidationException {
        List<String> resultColumnIds = this.getResultColumnsIds(configuration);
        List<ColumnDto> columns = configuration.getNotAttachedColumns();
        Map<String, ColumnType> columnTypes = this.columnTypesResolver.resolve(columns);
        ColumnTranslation columnTranslation = null;
        String tableName = null;
        SearchLocationDto searchLocation = configuration.getSearch().getLocation();
        switch (RecordLocation.getByName(searchLocation.getType())) {
            case DOCUMENT_CLASS: {
                String documentClassName = searchLocation.getNotAttachedName();
                DocumentClass documentClass = this.documentClassResolver.resolve(documentClassName);
                if (documentClass == null) {
                    LOG.error((Object)("Klasa dokumentow o nazwie " + documentClassName + " nie istnieje w systemie"));
                }
                columnTranslation = this.getColumnTranslation(configuration, documentClass);
                tableName = this.documentClassResolver.resolveTableName(documentClass);
                break;
            }
            case DATABASE_TABLE: {
                columnTranslation = new ColumnTranslation();
                tableName = searchLocation.getNotAttachedName();
                break;
            }
            default: {
                throw new SaveValidationException();
            }
        }
        String validateAmountsQuery = this.buildValidateAmountsQuery(configuration, saveInfo, columnTypes, attachedRecords, tableName, columnTranslation);
        Map<String, AbstractStandardBasicType<?>> scalars = this.buildScalars(configuration, columnTypes, columnTranslation);
        LOG.info((Object)("Zapytanie dla walidacji ilosci: " + validateAmountsQuery));
        return this.remainingAmountResolver.resolve(configuration, validateAmountsQuery, resultColumnIds, scalars);
    }

    private List<String> getResultColumnsIds(ConfigurationDto configuration) {
        ArrayList<String> resultColumnIds = new ArrayList<String>();
        resultColumnIds.add(configuration.getSearch().getLocation().getPrimaryKey().getName());
        resultColumnIds.add("PZ_PARTIAL_AMOUNT");
        resultColumnIds.add(configuration.getPartialAttachmentConfiguration().getAmountColumnId());
        return resultColumnIds;
    }

    private String buildValidateAmountsQuery(ConfigurationDto configuration, SaveInfo saveInfo, Map<String, ColumnType> columnTypes, List<Record> attachedRecords, String tableName, ColumnTranslation columnTranslation) {
        List<String> selects = this.buildSelects(configuration, saveInfo, tableName, columnTypes, columnTranslation);
        List<String> conditions = this.buildConditions(configuration, attachedRecords);
        return this.queryResolver.resolveValidateQuery(selects, tableName, conditions);
    }

    private ColumnTranslation getColumnTranslation(ConfigurationDto configuration, DocumentClass documentClass) throws SaveValidationException {
        try {
            return this.columnTranslationResolver.resolve(configuration, false, documentClass);
        }
        catch (RecordProviderException exception) {
            throw new SaveValidationException();
        }
    }

    private List<String> buildSelects(ConfigurationDto configuration, SaveInfo saveInfo, String tableName, Map<String, ColumnType> columnTypes, ColumnTranslation columnTranslation) {
        ArrayList<String> selects = new ArrayList<String>();
        selects.add(configuration.getSearch().getLocation().getPrimaryKey().getName());
        selects.add(this.partialAttachmentSubqueryResolver.resolveNotAttachedPartialAmountSelect(configuration, saveInfo.getParentValues(), tableName, columnTypes, columnTranslation));
        selects.add(columnTranslation.getTranslation(configuration.getPartialAttachmentConfiguration().getAmountColumnId()));
        return selects;
    }

    private List<String> buildConditions(ConfigurationDto configuration, List<Record> attachedRecords) {
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add(this.buildRecordsCondition(configuration, attachedRecords));
        return conditions;
    }

    private String buildRecordsCondition(ConfigurationDto configuration, List<Record> attachedRecords) {
        List<String> subConditions = this.buildRecordsSubConditions(configuration, attachedRecords);
        StringBuilder condition = new StringBuilder();
        condition.append("(");
        condition.append(StringUtils.join(subConditions, (String)OR_JOINER));
        condition.append(")");
        return condition.toString();
    }

    private List<String> buildRecordsSubConditions(ConfigurationDto configuration, List<Record> attachedRecords) {
        ArrayList<String> subConditions = new ArrayList<String>();
        PrimaryKeyDto primaryKey = configuration.getSearch().getLocation().getPrimaryKey();
        String primaryKeyName = primaryKey.getName();
        PrimaryKeyType primaryKeyType = PrimaryKeyType.getByName(primaryKey.getType());
        for (Record record : attachedRecords) {
            subConditions.add(this.buildRecordSubCondition(primaryKeyName, primaryKeyType, record));
        }
        return subConditions;
    }

    private String buildRecordSubCondition(String primaryKeyName, PrimaryKeyType primaryKeyType, Record record) {
        String primaryKeyValue = record.getValue(primaryKeyName);
        StringBuilder condition = new StringBuilder();
        condition.append(primaryKeyName);
        condition.append("=");
        condition.append(primaryKeyType.getConditionSuffix());
        condition.append(QueryUtils.getSafeValue(primaryKeyValue));
        condition.append(primaryKeyType.getConditionSuffix());
        return condition.toString();
    }

    private Map<String, AbstractStandardBasicType<?>> buildScalars(ConfigurationDto configuration, Map<String, ColumnType> columnTypes, ColumnTranslation columnTranslation) {
        String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
        ColumnType primaryKeyColumnType = columnTypes.get(primaryKeyName);
        String totalName = configuration.getPartialAttachmentConfiguration().getAmountColumnId();
        ColumnType totalColumnType = columnTypes.get(totalName);
        LinkedHashMap scalars = new LinkedHashMap();
        scalars.put(primaryKeyName, primaryKeyColumnType.getScalar());
        scalars.put("PZ_PARTIAL_AMOUNT", (AbstractStandardBasicType<?>)StandardBasicTypes.DOUBLE);
        scalars.put(columnTranslation.getTranslation(totalName), totalColumnType.getScalar());
        return scalars;
    }

    private List<ValidationError> validate(ConfigurationDto configuration, Map<String, AttachedAmount> attachedAmounts, List<RemainingAmount> remainingAmounts) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (RemainingAmount remainingAmount : remainingAmounts) {
            errors.addAll(this.validate(configuration, attachedAmounts, remainingAmount));
        }
        return errors;
    }

    private List<ValidationError> validate(ConfigurationDto configuration, Map<String, AttachedAmount> attachedAmounts, RemainingAmount remainingAmount) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        String primaryKeyValue = remainingAmount.getPrimaryKeyValue();
        AttachedAmount attachedAmount = attachedAmounts.get(primaryKeyValue);
        if (BooleanUtils.isTrue((Boolean)configuration.getPartialAttachmentConfiguration().getAllowNegative())) {
            if (this.isSignError(attachedAmount, remainingAmount)) {
                errors.add(this.buildValidationError(primaryKeyValue));
            } else if (this.isPosivite(remainingAmount)) {
                errors.addAll(this.validate(attachedAmount.getDifference(), remainingAmount.getAmount(), primaryKeyValue));
            } else {
                errors.addAll(this.validate(-1.0 * attachedAmount.getDifference(), Math.abs(remainingAmount.getAmount()), primaryKeyValue));
            }
        } else {
            errors.addAll(this.validate(attachedAmount.getDifference(), remainingAmount.getAmount(), primaryKeyValue));
        }
        return errors;
    }

    private boolean isSignError(AttachedAmount attachedAmount, RemainingAmount remainingAmount) {
        return Math.signum(attachedAmount.getAmount()) != Math.signum(remainingAmount.getTotal());
    }

    private boolean isPosivite(RemainingAmount remainingAmount) {
        return Math.signum(remainingAmount.getTotal()) > 0.0;
    }

    private List<ValidationError> validate(Double attachedAmount, Double remainingAmount, String primaryKeyValue) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (MathUtils.subtract(remainingAmount, attachedAmount) < 0.0) {
            errors.add(this.buildValidationError(primaryKeyValue));
        }
        return errors;
    }

    private ValidationError buildValidationError(String primaryKeyValue) {
        ValidationError error = new ValidationError();
        error.setAmountError(true);
        error.setPrimaryKeyValue(primaryKeyValue);
        return error;
    }
}

