/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.service.record;

import com.suncode.plugin.pzmodule.api.dto.configuration.ColumnDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.exception.RecordProviderException;
import com.suncode.plugin.pzmodule.api.info.AttachedInfo;
import com.suncode.plugin.pzmodule.api.info.FilterInfo;
import com.suncode.plugin.pzmodule.api.info.PagingInfo;
import com.suncode.plugin.pzmodule.api.info.SearchInfo;
import com.suncode.plugin.pzmodule.api.info.SortInfo;
import com.suncode.plugin.pzmodule.api.provider.record.RecordProvider;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.api.record.RecordPage;
import com.suncode.plugin.pzmodule.api.result.GroupSumResult;
import com.suncode.plugin.pzmodule.api.result.SumAllResult;
import com.suncode.plugin.pzmodule.evaluator.RecordExpressionEvaluator;
import com.suncode.plugin.pzmodule.object.RecordUpdate;
import com.suncode.plugin.pzmodule.resolver.configuration.ConfigurationResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.RecordProviderResolver;
import com.suncode.plugin.pzmodule.service.configuration.AdministrationConfigurationService;
import com.suncode.plugin.pzmodule.service.record.RecordService;
import com.suncode.plugin.pzmodule.translation.Translator;
import com.suncode.plugin.pzmodule.web.rest.support.CountedDataResult;
import com.suncode.plugin.pzmodule.web.rest.support.DataResult;
import com.suncode.plugin.pzmodule.web.rest.support.DatumResult;
import com.suncode.plugin.pzmodule.web.rest.support.builder.CountedDataResultBuilder;
import com.suncode.plugin.pzmodule.web.rest.support.builder.DataResultBuilder;
import com.suncode.plugin.pzmodule.web.rest.support.builder.DatumResultBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecordServiceImpl
implements RecordService {
    private static final Logger LOG = Logger.getLogger(RecordServiceImpl.class);
    private static final String CONFIGURATION_NOT_FOUND_MESSAGE = "pzmodule.program.configuration.notfound";
    private static final String CONFIGURATION_ERROR_MESSAGE = "pzmodule.program.configuration.error";
    private static final String GET_DATA_ERROR_MESSAGE = "pzmodule.program.record.getdataerror";
    @Autowired
    private AdministrationConfigurationService administrationConfigurationService;
    @Autowired
    private RecordProviderResolver recordProviderResolver;
    @Autowired
    private CountedDataResultBuilder<Record> recordDataResultBuilder;
    @Autowired
    private ConfigurationResolver configurationResolver;
    @Autowired
    private RecordExpressionEvaluator recordExpressionEvaluator;
    @Autowired
    private DatumResultBuilder<Record> recordDatumResultBuilder;
    @Autowired
    private DataResultBuilder<GroupSumResult> groupSumDataResultBuilder;
    @Autowired
    private DatumResultBuilder<SumAllResult> sumAllDataResultBuilder;
    @Autowired
    private Translator translator;

    @Override
    public CountedDataResult<Record> get(String configurationId, boolean attached, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo, SortInfo sortInfo, PagingInfo pagingInfo) {
        ConfigurationDto configuration = this.administrationConfigurationService.find(configurationId);
        if (configuration == null) {
            return this.recordDataResultBuilder.buildError(this.buildConfigurationNotFoundMessage());
        }
        RecordProvider provider = this.recordProviderResolver.resolve(configuration);
        if (provider == null) {
            return this.recordDataResultBuilder.buildError(this.buildConfigurationErrorMessage());
        }
        try {
            RecordPage page = provider.getPage(configuration, attached, attachedInfo, searchInfo, filterInfo, sortInfo, pagingInfo);
            return this.recordDataResultBuilder.build(page.getData(), page.getTotal());
        }
        catch (RecordProviderException exception) {
            return this.recordDataResultBuilder.buildError(exception.getMessage());
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            return this.recordDataResultBuilder.buildError(this.buildGetDataErrorMessage());
        }
    }

    private String buildConfigurationNotFoundMessage() {
        return this.translator.translateMessage(CONFIGURATION_NOT_FOUND_MESSAGE);
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR_MESSAGE);
    }

    private String buildGetDataErrorMessage() {
        return this.translator.translateMessage(GET_DATA_ERROR_MESSAGE);
    }

    @Override
    public DatumResult<Record> update(RecordUpdate recordUpdate) {
        String configurationId = recordUpdate.getConfigurationId();
        ConfigurationDto configuration = this.administrationConfigurationService.find(configurationId);
        Record record = recordUpdate.getRecord();
        if (configuration != null) {
            boolean attached = recordUpdate.getAttached();
            Map<String, Object> activityContext = recordUpdate.getActivityContext();
            Map<String, Object> extraParameters = recordUpdate.getExtraParameters();
            String modifiedColumnId = recordUpdate.getModifiedColumnId();
            List<ColumnDto> columns = this.configurationResolver.resolveColumns(configuration, attached);
            LinkedHashMap<String, String> expressions = new LinkedHashMap<String, String>();
            for (ColumnDto column : columns) {
                if (!StringUtils.isNotBlank((CharSequence)column.getExpression())) continue;
                expressions.put(column.getDataIndex(), column.getExpression());
            }
            record = this.evaluateExpressions(record, activityContext, extraParameters, modifiedColumnId, expressions);
        }
        return this.recordDatumResultBuilder.build(record);
    }

    private Record evaluateExpressions(Record record, Map<String, Object> activityContext, Map<String, Object> extraParameters, String modifiedColumnId, Map<String, String> expressions) {
        return this.recordExpressionEvaluator.evaluate(record, activityContext, extraParameters, modifiedColumnId, expressions);
    }

    @Override
    public DataResult<GroupSumResult> sum(String configurationId, boolean attached, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo) {
        ConfigurationDto configuration = this.administrationConfigurationService.find(configurationId);
        if (configuration == null) {
            return this.groupSumDataResultBuilder.buildError(this.buildConfigurationNotFoundMessage());
        }
        RecordProvider provider = this.recordProviderResolver.resolve(configuration);
        if (provider == null) {
            return this.groupSumDataResultBuilder.buildError(this.buildConfigurationErrorMessage());
        }
        try {
            List<GroupSumResult> results = provider.sumInGroup(configuration, attached, attachedInfo, searchInfo, filterInfo);
            return this.groupSumDataResultBuilder.build(results);
        }
        catch (RecordProviderException exception) {
            return this.groupSumDataResultBuilder.buildError(exception.getMessage());
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            return this.groupSumDataResultBuilder.buildError(this.buildGetDataErrorMessage());
        }
    }

    @Override
    public DatumResult<SumAllResult> sumAll(String configurationId, boolean attached, String columnId, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo) {
        ConfigurationDto configuration = this.administrationConfigurationService.find(configurationId);
        if (configuration == null) {
            return this.sumAllDataResultBuilder.buildError(this.buildConfigurationNotFoundMessage());
        }
        RecordProvider provider = this.recordProviderResolver.resolve(configuration);
        if (provider == null) {
            return this.sumAllDataResultBuilder.buildError(this.buildConfigurationErrorMessage());
        }
        try {
            SumAllResult result = provider.sumAll(configuration, attached, columnId, attachedInfo, searchInfo, filterInfo);
            return this.sumAllDataResultBuilder.build(result);
        }
        catch (RecordProviderException exception) {
            return this.sumAllDataResultBuilder.buildError(exception.getMessage());
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            return this.sumAllDataResultBuilder.buildError(this.buildGetDataErrorMessage());
        }
    }
}

