/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.service.partialattachment;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.info.support.ParentValues;
import com.suncode.plugin.pzmodule.dao.partialattachment.PartialAttachmentDao;
import com.suncode.plugin.pzmodule.model.partialattachment.PartialAttachment;
import com.suncode.plugin.pzmodule.resolver.parentvalue.ParentValueResolver;
import com.suncode.plugin.pzmodule.resolver.partialattachment.PartialAttachmentResolver;
import com.suncode.plugin.pzmodule.service.partialattachment.PartialAttachmentService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PartialAttachmentServiceImpl
implements PartialAttachmentService {
    @Autowired
    private ParentValueResolver parentValueResolver;
    @Autowired
    private PartialAttachmentResolver partialAttachmentResolver;
    @Autowired
    private PartialAttachmentDao partialAttachmentDao;

    @Override
    @Transactional
    public void attach(ConfigurationDto configuration, SaveInfo saveInfo, String primaryKeyValue, Double amount) {
        String primaryKeyType = configuration.getSearch().getLocation().getPrimaryKey().getType();
        PartialAttachment partialAttachment = this.getPartialAttachment(configuration, saveInfo, primaryKeyType, primaryKeyValue);
        if (partialAttachment == null) {
            partialAttachment = this.buildPartialAttachment(configuration, saveInfo, primaryKeyType, primaryKeyValue, amount);
        } else {
            partialAttachment.setAmount(amount);
        }
        this.partialAttachmentDao.save(partialAttachment);
    }

    @Override
    @Transactional
    public void detach(ConfigurationDto configuration, SaveInfo saveInfo, String primaryKeyValue) {
        String primaryKeyType = configuration.getSearch().getLocation().getPrimaryKey().getType();
        PartialAttachment partialAttachment = this.getPartialAttachment(configuration, saveInfo, primaryKeyType, primaryKeyValue);
        if (partialAttachment != null) {
            this.partialAttachmentDao.delete(partialAttachment);
        }
    }

    private PartialAttachment getPartialAttachment(ConfigurationDto configuration, SaveInfo saveInfo, String primaryKeyType, String primaryKeyValue) {
        ParentValues parentValues = saveInfo.getParentValues();
        String configurationId = this.parentValueResolver.resolveConfigurationId(configuration, parentValues);
        String processId = this.parentValueResolver.resolveProcessId(configuration, saveInfo.getProcessId(), parentValues);
        switch (ColumnType.getByName(primaryKeyType)) {
            case INT: {
                return this.getIntPartialAttachment(configurationId, processId, primaryKeyValue);
            }
            case FLOAT: {
                return this.getFloatPartialAttachment(configurationId, processId, primaryKeyValue);
            }
        }
        return this.getStringPartialAttachment(configurationId, processId, primaryKeyValue);
    }

    private PartialAttachment getIntPartialAttachment(String configurationId, String processId, String primaryKeyValue) {
        Long intPrimaryKeyValue = this.buildIntPrimaryKeyValue(primaryKeyValue);
        return this.partialAttachmentDao.getForIntValue(configurationId, processId, intPrimaryKeyValue);
    }

    private PartialAttachment getFloatPartialAttachment(String configurationId, String processId, String primaryKeyValue) {
        Double floatPrimaryKeyValue = this.buildFloatPrimaryKeyValue(primaryKeyValue);
        return this.partialAttachmentDao.getForFloatValue(configurationId, processId, floatPrimaryKeyValue);
    }

    private PartialAttachment getStringPartialAttachment(String configurationId, String processId, String primaryKeyValue) {
        return this.partialAttachmentDao.getForStringValue(configurationId, processId, primaryKeyValue);
    }

    private PartialAttachment buildPartialAttachment(ConfigurationDto configuration, SaveInfo saveInfo, String primaryKeyType, String primaryKeyValue, Double amount) {
        ParentValues parentValues = saveInfo.getParentValues();
        String configurationId = this.parentValueResolver.resolveConfigurationId(configuration, parentValues);
        String processId = this.parentValueResolver.resolveProcessId(configuration, saveInfo.getProcessId(), parentValues);
        switch (ColumnType.getByName(primaryKeyType)) {
            case INT: {
                return this.buildIntPartialAttachment(configurationId, processId, primaryKeyValue, amount);
            }
            case FLOAT: {
                return this.buildFloatPartialAttachment(configurationId, processId, primaryKeyValue, amount);
            }
        }
        return this.buildStringPartialAttachment(configurationId, processId, primaryKeyValue, amount);
    }

    private PartialAttachment buildIntPartialAttachment(String configurationId, String processId, String primaryKeyValue, Double amount) {
        Long intPrimaryKeyValue = this.buildIntPrimaryKeyValue(primaryKeyValue);
        return this.partialAttachmentResolver.resolve(configurationId, processId, intPrimaryKeyValue, amount);
    }

    private PartialAttachment buildFloatPartialAttachment(String configurationId, String processId, String primaryKeyValue, Double amount) {
        Double floatPrimaryKeyValue = this.buildFloatPrimaryKeyValue(primaryKeyValue);
        return this.partialAttachmentResolver.resolve(configurationId, processId, floatPrimaryKeyValue, amount);
    }

    private PartialAttachment buildStringPartialAttachment(String configurationId, String processId, String primaryKeyValue, Double amount) {
        return this.partialAttachmentResolver.resolve(configurationId, processId, primaryKeyValue, amount);
    }

    private Long buildIntPrimaryKeyValue(String primaryKeyValue) {
        return primaryKeyValue != null ? Long.valueOf(primaryKeyValue) : null;
    }

    private Double buildFloatPrimaryKeyValue(String primaryKeyValue) {
        return primaryKeyValue != null ? Double.valueOf(primaryKeyValue) : null;
    }

    @Override
    @Transactional
    public void remove(String configurationId, String processId) {
        List<PartialAttachment> partialAttachments = this.partialAttachmentDao.getForProcess(configurationId, processId);
        if (CollectionUtils.isNotEmpty(partialAttachments)) {
            for (PartialAttachment partialAttachment : partialAttachments) {
                this.partialAttachmentDao.delete(partialAttachment);
            }
        }
    }
}

