/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordsaver;

import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionParameterDto;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionParameterOperation;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionParameterType;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.evaluator.SaveActionParameterEvaluator;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.resolver.recordsaver.SummaryDataSourceResolver;
import com.suncode.plugin.pzmodule.translation.Translator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SummaryDataSourceResolverImpl
implements SummaryDataSourceResolver {
    private static final Logger LOG = Logger.getLogger(SummaryDataSourceResolverImpl.class);
    private static final String SEQUENCER_FIELD_NAME = "PZSequencer";
    private static final String DATA_SOURCE_KEY = "pz";
    private static final String CONFIGURATION_ERROR_MESSAGE = "pzmodule.program.configuration.error";
    @Autowired
    private SaveActionParameterEvaluator saveActionParameterEvaluator;
    @Autowired
    private Translator translator;

    @Override
    public Map<String, Map<String, Object>> resolve(SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords, Map<String, Object> activityContext, String primaryKeyName) throws SaveActionExecutorException {
        HashMap<String, Map<String, Object>> dataSource = new HashMap<String, Map<String, Object>>();
        HashMap<String, String> datumSource = new HashMap<String, String>();
        Record emptyRecord = new Record();
        if (CollectionUtils.isNotEmpty(saveAction.getParameters())) {
            ArrayList<String> attachedPrimaryKeyValues = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty(attachedRecords)) {
                for (Record attachedRecord : attachedRecords) {
                    String primaryKeyValue = attachedRecord.getValue(primaryKeyName);
                    attachedPrimaryKeyValues.add(primaryKeyValue);
                }
            }
            List<Record> detachedRecords = this.getDetachedRecords(saveInfo, attachedPrimaryKeyValues, primaryKeyName);
            for (SaveActionParameterDto saveActionParameter : saveAction.getParameters()) {
                SaveActionParameterType type = SaveActionParameterType.getByName(saveActionParameter.getType());
                String to = saveActionParameter.getToValue();
                if (StringUtils.isBlank((CharSequence)to)) {
                    LOG.error((Object)"Brak wartosci docelowej dla parametru akcji zapisu");
                    throw new SaveActionExecutorException(this.buildConfigurationErrorMessage());
                }
                if (type.equals((Object)SaveActionParameterType.SUMMARY)) {
                    String value = this.saveActionParameterEvaluator.evaluate(saveActionParameter, saveInfo, emptyRecord, attachedRecords, activityContext, primaryKeyName, "", false);
                    datumSource.put(to, value);
                    continue;
                }
                if (!type.equals((Object)SaveActionParameterType.PZ)) continue;
                String from = saveActionParameter.getFromValue();
                String value = "";
                if (StringUtils.equals((CharSequence)from, (CharSequence)SEQUENCER_FIELD_NAME)) {
                    ArrayList<String> positions = new ArrayList<String>();
                    for (int positionNo = 1; positionNo <= CollectionUtils.size(attachedRecords); ++positionNo) {
                        positions.add(String.valueOf(positionNo));
                    }
                    value = StringUtils.join(positions, (String)type.getValueJoiner());
                } else {
                    value = SaveActionParameterOperation.VALUE.calculate(from, "", emptyRecord, attachedRecords, detachedRecords, activityContext, type.getValueJoiner(), "", "", type.isAccumulate(), false);
                }
                datumSource.put(to, value);
            }
        }
        if (MapUtils.isNotEmpty(datumSource)) {
            dataSource.put(DATA_SOURCE_KEY, datumSource);
        }
        return dataSource;
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR_MESSAGE);
    }

    private List<Record> getDetachedRecords(SaveInfo saveInfo, List<String> attachedPrimaryKeyValues, String primaryKeyName) {
        ArrayList<Record> records = new ArrayList<Record>();
        if (CollectionUtils.isNotEmpty(saveInfo.getInitiallyAttachedRecords())) {
            for (Record record : saveInfo.getInitiallyAttachedRecords()) {
                String primaryKeyValue = record.getValue(primaryKeyName);
                if (attachedPrimaryKeyValues.contains(primaryKeyValue)) continue;
                records.add(record);
            }
        }
        return records;
    }
}

