/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordsaver;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.resolver.recordsaver.SaveActionResolver;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.SaveActionDtoBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SaveActionResolverImpl
implements SaveActionResolver {
    @Autowired
    private SaveActionDtoBuilder saveActionDtoBuilder;

    @Override
    public List<SaveActionDto> resolve(ConfigurationDto configuration) {
        ArrayList<SaveActionDto> saveActions = new ArrayList<SaveActionDto>();
        if (CollectionUtils.isNotEmpty(configuration.getSave().getActions())) {
            saveActions.addAll(configuration.getSave().getActions());
        }
        if (this.isPartialAttachmentActive(configuration)) {
            saveActions.add(this.buildPartialAttachmentAction());
        } else if (this.isDuplicateChoiceDisabled(configuration)) {
            saveActions.add(this.buildUsed());
        }
        return saveActions;
    }

    private boolean isPartialAttachmentActive(ConfigurationDto configuration) {
        return StringUtils.isNotBlank((CharSequence)configuration.getPartialAttachmentConfiguration().getAmountColumnId());
    }

    private boolean isDuplicateChoiceDisabled(ConfigurationDto configuration) {
        return BooleanUtils.isNotTrue((Boolean)configuration.getEnableDuplicateChoice());
    }

    private SaveActionDto buildPartialAttachmentAction() {
        return this.saveActionDtoBuilder.buildPartialAttachment();
    }

    private SaveActionDto buildUsed() {
        return this.saveActionDtoBuilder.buildUsed();
    }
}

