/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.dto.configuration.SearchCriterionDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.enumeration.Operator;
import com.suncode.plugin.pzmodule.api.enumeration.SearchCriterionType;
import com.suncode.plugin.pzmodule.api.exception.RecordProviderException;
import com.suncode.plugin.pzmodule.object.WhereCondition;
import com.suncode.plugin.pzmodule.resolver.recordprovider.WhereConditionResolver;
import com.suncode.plugin.pzmodule.translation.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WhereConditionResolverImpl
implements WhereConditionResolver {
    private static final Logger LOG = Logger.getLogger(WhereConditionResolverImpl.class);
    private static final String UNKNOWN_SEARCH_CRITERION_MESSAGE = "pzmodule.program.record.unknownsearchcriterion";
    private static final String NO_SEARCH_PARAMETER_MESSAGE = "pzmodule.program.record.nosearchparameter";
    @Autowired
    private Translator translator;

    @Override
    public List<WhereCondition> resolve(List<SearchCriterionDto> searchCriteria, Map<String, Object> activityContext, Map<String, Object> extraParameters, Map<String, ColumnType> columnTypes) throws RecordProviderException {
        ArrayList<WhereCondition> conditions = new ArrayList<WhereCondition>();
        for (SearchCriterionDto searchCriterion : searchCriteria) {
            String[] values;
            if (!this.shouldResolve(searchCriterion, values = this.resolveValues(searchCriterion, activityContext, extraParameters))) continue;
            conditions.add(this.resolve(searchCriterion, values, columnTypes));
        }
        return conditions;
    }

    private String[] resolveValues(SearchCriterionDto searchCriterion, Map<String, Object> activityContext, Map<String, Object> extraParameters) throws RecordProviderException {
        switch (SearchCriterionType.getByName(searchCriterion.getType())) {
            case FIXED: {
                return new String[]{searchCriterion.getValue()};
            }
            case FIXED_COMA_SPLIT: {
                return this.resolveValues(searchCriterion.getValue(), ",");
            }
            case FIXED_SEMICOLON_SPLIT: {
                return this.resolveValues(searchCriterion.getValue(), ";");
            }
            case VARIABLE: {
                return new String[]{this.resolveVariableValue(searchCriterion, activityContext, extraParameters)};
            }
            case VARIABLE_COMA_SPLIT: {
                return this.resolveValues(this.resolveVariableValue(searchCriterion, activityContext, extraParameters), ",");
            }
            case VARIABLE_SEMICOLON_SPLIT: {
                return this.resolveValues(this.resolveVariableValue(searchCriterion, activityContext, extraParameters), ";");
            }
        }
        LOG.error((Object)("Nieznane kryterium wyszukiwania " + searchCriterion.getType()));
        throw new RecordProviderException(this.buildUnknownSearchCriterionMessage());
    }

    private String[] resolveValues(String value, String separator) {
        String[] stringArray;
        if (value != null) {
            stringArray = value.split(separator, -1);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        return stringArray;
    }

    private boolean shouldResolve(SearchCriterionDto searchCriterion, String[] values) {
        return BooleanUtils.isTrue((Boolean)searchCriterion.getAllowEmpty()) || this.hasNonEmptyValues(values);
    }

    private boolean hasNonEmptyValues(String[] values) {
        for (String value : values) {
            if (!StringUtils.isEmpty((CharSequence)value)) continue;
            return false;
        }
        return true;
    }

    private WhereCondition resolve(SearchCriterionDto searchCriterion, String[] values, Map<String, ColumnType> columnTypes) {
        WhereCondition condition = new WhereCondition();
        condition.setKey(searchCriterion.getMapping());
        condition.setOperator(Operator.getByName(searchCriterion.getOperator()));
        condition.setValues(values);
        if (columnTypes.containsKey(searchCriterion.getMapping())) {
            ColumnType columnType = columnTypes.get(searchCriterion.getMapping());
            condition.setSuffix(columnType.getConditionSuffix());
        } else {
            condition.setSuffix("'");
        }
        return condition;
    }

    private String resolveVariableValue(SearchCriterionDto searchCriterion, Map<String, Object> activityContext, Map<String, Object> extraParameters) throws RecordProviderException {
        String id = searchCriterion.getValue();
        if (this.hasNotSearchParameter(id, searchCriterion.getRequired(), activityContext, extraParameters)) {
            LOG.error((Object)("Brak wymaganej zmiennej procesu lub parametru o identyfikatorze " + id));
            throw new RecordProviderException(this.buildNoSearchParameterMessage());
        }
        Object variableValue = this.resolveVariableValue(id, activityContext, extraParameters);
        return variableValue != null ? variableValue.toString() : "";
    }

    private boolean hasNotSearchParameter(String id, Boolean required, Map<String, Object> activityContext, Map<String, Object> extraParameters) {
        return !activityContext.containsKey(id) && !extraParameters.containsKey(id) && !BooleanUtils.isNotTrue((Boolean)required);
    }

    private Object resolveVariableValue(String id, Map<String, Object> activityContext, Map<String, Object> extraParameters) {
        if (activityContext.containsKey(id)) {
            return activityContext.get(id);
        }
        return extraParameters.get(id);
    }

    private String buildUnknownSearchCriterionMessage() {
        return this.translator.translateMessage(UNKNOWN_SEARCH_CRITERION_MESSAGE);
    }

    private String buildNoSearchParameterMessage() {
        return this.translator.translateMessage(NO_SEARCH_PARAMETER_MESSAGE);
    }
}

