/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PartialAttachmentConfigurationDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.info.SearchInfo;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.resolver.recordprovider.PartialAttachmentSubqueryResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.SumResolver;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SumResolverImpl
implements SumResolver {
    private static final String SUM_ALIAS_PREFIX = "SUM_";
    @Autowired
    private PartialAttachmentSubqueryResolver partialAttachmentSubqueryResolver;

    @Override
    public String resolveAlias(String columnId, ColumnTranslation columnTranslation) {
        StringBuilder alias = new StringBuilder();
        alias.append(SUM_ALIAS_PREFIX);
        alias.append(columnTranslation.getTranslation(columnId));
        return alias.toString();
    }

    @Override
    public String resolveSelect(ConfigurationDto configuration, SearchInfo searchInfo, String columnId, String sumAlias, String tableName, Map<String, ColumnType> columnTypes, ColumnTranslation columnTranslation) {
        String partialAmountSumSelect = this.resolvePartialAmountSumSelect(configuration, searchInfo, columnId, tableName, columnTypes);
        StringBuilder select = new StringBuilder();
        select.append("(");
        select.append("SUM(");
        select.append(columnTranslation.getTranslation(columnId));
        select.append(")");
        if (StringUtils.isNotBlank((CharSequence)partialAmountSumSelect)) {
            select.append(" - ");
            select.append(partialAmountSumSelect);
        }
        select.append(")");
        select.append(" AS ");
        select.append(sumAlias);
        return select.toString();
    }

    private String resolvePartialAmountSumSelect(ConfigurationDto configuration, SearchInfo searchInfo, String columnId, String tableName, Map<String, ColumnType> columnTypes) {
        if (this.isPartialAttachmentShowMySeparatedActiveForGroupSum(configuration, columnId)) {
            return this.partialAttachmentSubqueryResolver.resolvePartialAmountSumSelect(configuration, searchInfo.getParentValues(), tableName, columnTypes);
        }
        return "";
    }

    private boolean isPartialAttachmentShowMySeparatedActiveForGroupSum(ConfigurationDto configuration, String columnId) {
        PartialAttachmentConfigurationDto partialAttachmentConfiguration = configuration.getPartialAttachmentConfiguration();
        return BooleanUtils.isTrue((Boolean)partialAttachmentConfiguration.getShowMySeparated()) && StringUtils.equals((CharSequence)partialAttachmentConfiguration.getAmountColumnId(), (CharSequence)columnId);
    }
}

