/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.resolver.recordprovider.QueryResolver;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class QueryResolverImpl
implements QueryResolver {
    private static final String AND_JOINER = " AND ";

    @Override
    public String resolveDataQuery(List<String> selects, String tableName, String subGroupsFilterQueryPart, List<String> conditions, List<String> sorters) {
        StringBuilder query = new StringBuilder();
        query.append(this.resolveSelectFromQueryPart(selects, tableName));
        query.append(this.resolveSubGroupsFilterQueryPart(subGroupsFilterQueryPart));
        query.append(this.resolveAndConditionsQueryPart(conditions));
        query.append(this.resolveSortersQueryPart(sorters));
        return query.toString();
    }

    @Override
    public String resolveCountQuery(String tableName, String subGroupsFilterQueryPart, List<String> conditions) {
        String countSelect = this.resolveCountSelect();
        StringBuilder query = new StringBuilder();
        query.append(this.resolveSelectFromQueryPart(countSelect, tableName));
        query.append(this.resolveSubGroupsFilterQueryPart(subGroupsFilterQueryPart));
        query.append(this.resolveAndConditionsQueryPart(conditions));
        return query.toString();
    }

    @Override
    public String resolveSumsQuery(List<String> selects, String tableName, String subGroupsFilterQueryPart, List<String> conditions, String groupBy) {
        StringBuilder query = new StringBuilder();
        query.append(this.resolveSelectFromQueryPart(selects, tableName));
        query.append(this.resolveSubGroupsFilterQueryPart(subGroupsFilterQueryPart));
        query.append(this.resolveAndConditionsQueryPart(conditions));
        query.append(this.resolveGroupByQueryPart(groupBy));
        return query.toString();
    }

    @Override
    public String resolveSumAllQuery(String select, String tableName, List<String> conditions) {
        StringBuilder query = new StringBuilder();
        query.append(this.resolveSelectFromQueryPart(select, tableName));
        query.append(this.resolveAndConditionsQueryPart(conditions));
        return query.toString();
    }

    @Override
    public String resolveValidateQuery(List<String> selects, String tableName, List<String> conditions) {
        StringBuilder query = new StringBuilder();
        query.append(this.resolveSelectFromQueryPart(selects, tableName));
        query.append(this.resolveAndConditionsQueryPart(conditions));
        return query.toString();
    }

    private String resolveSelectFromQueryPart(List<String> selects, String tableName) {
        StringBuilder queryPart = new StringBuilder("SELECT ");
        queryPart.append(StringUtils.join(selects, (String)", "));
        queryPart.append(" FROM ");
        queryPart.append(tableName);
        return queryPart.toString();
    }

    private String resolveCountSelect() {
        StringBuilder queryPart = new StringBuilder("COUNT(*) AS ");
        queryPart.append("PZ_TOTAL_COUNT");
        return queryPart.toString();
    }

    private String resolveSelectFromQueryPart(String select, String tableName) {
        StringBuilder queryPart = new StringBuilder("SELECT ");
        queryPart.append(select);
        queryPart.append(" FROM ");
        queryPart.append(tableName);
        return queryPart.toString();
    }

    private String resolveSubGroupsFilterQueryPart(String subGroupsFilterQueryPart) {
        StringBuilder queryPart = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)subGroupsFilterQueryPart)) {
            queryPart.append(" ");
            queryPart.append(subGroupsFilterQueryPart);
        }
        return queryPart.toString();
    }

    private String resolveAndConditionsQueryPart(List<String> conditions) {
        return this.resolveConditionsQueryPart(conditions, AND_JOINER);
    }

    private String resolveConditionsQueryPart(List<String> conditions, String joiner) {
        StringBuilder queryPart = new StringBuilder();
        if (CollectionUtils.isNotEmpty(conditions)) {
            queryPart.append(" WHERE ");
            queryPart.append(StringUtils.join(conditions, (String)joiner));
        }
        return queryPart.toString();
    }

    private String resolveSortersQueryPart(List<String> sorters) {
        StringBuilder queryPart = new StringBuilder();
        if (CollectionUtils.isNotEmpty(sorters)) {
            queryPart.append(" ORDER BY ");
            queryPart.append(StringUtils.join(sorters, (String)", "));
        }
        return queryPart.toString();
    }

    private String resolveGroupByQueryPart(String groupBy) {
        StringBuilder queryPart = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)groupBy)) {
            queryPart.append(" GROUP BY ");
            queryPart.append(groupBy);
        }
        return queryPart.toString();
    }
}

