/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.info.SearchInfo;
import com.suncode.plugin.pzmodule.api.info.support.ParentValues;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.resolver.parentvalue.ParentValueResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.PartialAttachmentSubqueryResolver;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PartialAttachmentSubqueryResolverImpl
implements PartialAttachmentSubqueryResolver {
    @Autowired
    private ParentValueResolver parentValueResolver;

    @Override
    public String resolvePartialAmountSelect(ConfigurationDto configuration, boolean attached, SearchInfo searchInfo, String tableName, Map<String, ColumnType> columnTypes, ColumnTranslation columnTranslation) {
        return attached ? this.resolveAttachedPartialAmountSelect(configuration, searchInfo, tableName, columnTypes) : this.resolveNotAttachedPartialAmountSelect(configuration, searchInfo.getParentValues(), tableName, columnTypes, columnTranslation);
    }

    @Override
    public String resolveAttachedPartialAmountSelect(ConfigurationDto configuration, SearchInfo searchInfo, String tableName, Map<String, ColumnType> columnTypes) {
        ParentValues parentValues = searchInfo.getParentValues();
        StringBuilder subquery = new StringBuilder();
        subquery.append("(SELECT amount ");
        subquery.append(this.resolveCommonSubPart(configuration, parentValues, tableName, columnTypes, false));
        subquery.append(" AND process_id='");
        subquery.append(this.parentValueResolver.resolveProcessId(configuration, searchInfo.getProcessId(), parentValues));
        subquery.append("')");
        subquery.append(this.resolvePartialAmountAliasSubPart());
        return subquery.toString();
    }

    @Override
    public String resolveNotAttachedPartialAmountSelect(ConfigurationDto configuration, ParentValues parentValues, String tableName, Map<String, ColumnType> columnTypes, ColumnTranslation columnTranslation) {
        StringBuilder subquery = new StringBuilder();
        subquery.append("(");
        subquery.append(columnTranslation.getTranslation(configuration.getPartialAttachmentConfiguration().getAmountColumnId()));
        subquery.append(" - ");
        subquery.append(this.resolvePartialAmountSumSelect(configuration, parentValues, tableName, columnTypes));
        subquery.append(")");
        subquery.append(this.resolvePartialAmountAliasSubPart());
        return subquery.toString();
    }

    private String resolveCommonSubPart(ConfigurationDto configuration, ParentValues parentValues, String tableName, Map<String, ColumnType> columnTypes, boolean useTwoTables) {
        String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
        ColumnType columnType = columnTypes.get(primaryKeyName);
        StringBuilder subPart = new StringBuilder();
        subPart.append("FROM ");
        subPart.append("pm_pzmodule_partial_att");
        if (useTwoTables) {
            subPart.append(", ");
            subPart.append(tableName);
        }
        subPart.append(" WHERE configuration_id='");
        subPart.append(this.parentValueResolver.resolveConfigurationId(configuration, parentValues));
        subPart.append("' AND ");
        subPart.append(tableName);
        subPart.append(".");
        subPart.append(primaryKeyName);
        subPart.append("=");
        subPart.append(columnType.getPartialAttachmentValueColumn());
        return subPart.toString();
    }

    private String resolvePartialAmountAliasSubPart() {
        StringBuilder subPart = new StringBuilder();
        subPart.append(" AS ");
        subPart.append("PZ_PARTIAL_AMOUNT");
        return subPart.toString();
    }

    @Override
    public String resolvePartialAmountSumSelect(ConfigurationDto configuration, ParentValues parentValues, String tableName, Map<String, ColumnType> columnTypes) {
        StringBuilder subquery = new StringBuilder();
        subquery.append("COALESCE((SELECT SUM(amount) ");
        subquery.append(this.resolveCommonSubPart(configuration, parentValues, tableName, columnTypes, false));
        subquery.append("), 0)");
        return subquery.toString();
    }
}

