/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.info.support.GetGroup;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.api.util.QueryUtils;
import com.suncode.plugin.pzmodule.resolver.recordprovider.GetGroupQueryPartResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class GetGroupQueryPartResolverImpl
implements GetGroupQueryPartResolver {
    @Override
    public List<String> resolve(List<GetGroup> getGroups, Map<String, ColumnType> columnTypes, ColumnTranslation columnTranslation) {
        ArrayList<String> parts = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(getGroups)) {
            for (GetGroup getGroup : getGroups) {
                if (!this.shouldResolve(getGroup)) continue;
                parts.add(this.resolve(getGroup, columnTypes, columnTranslation));
            }
        }
        return parts;
    }

    private boolean shouldResolve(GetGroup getGroup) {
        return StringUtils.isNotBlank((CharSequence)getGroup.getId());
    }

    @Override
    public String resolve(GetGroup getGroup, Map<String, ColumnType> columnTypes, ColumnTranslation columnTranslation) {
        ColumnType columnType = this.getColumnType(getGroup.getId(), columnTypes);
        StringBuilder subPart = new StringBuilder();
        subPart.append(columnTranslation.getTranslation(getGroup.getId()));
        subPart.append("=");
        subPart.append(columnType.getConditionSuffix());
        subPart.append(QueryUtils.getSafeValue(getGroup.getValue()));
        subPart.append(columnType.getConditionSuffix());
        return subPart.toString();
    }

    private ColumnType getColumnType(String groupId, Map<String, ColumnType> columnTypes) {
        if (columnTypes.containsKey(groupId)) {
            return columnTypes.get(groupId);
        }
        return ColumnType.STRING;
    }
}

