/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.google.common.collect.Lists;
import com.suncode.plugin.pzmodule.api.dto.configuration.FilterRelationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.RelatedFilterDto;
import com.suncode.plugin.pzmodule.api.enumeration.FilterType;
import com.suncode.plugin.pzmodule.api.info.support.Filter;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.resolver.recordprovider.FilterQueryPartResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FilterQueryPartResolverImpl
implements FilterQueryPartResolver {
    @Override
    public List<String> resolve(List<Filter> filters, List<FilterRelationDto> filterRelations, Map<String, String> dateStringInputFormats, ColumnTranslation columnTranslation) {
        ArrayList<String> parts = new ArrayList<String>();
        List<List<String>> filterIdRelations = this.buildFilterIdRelations(filterRelations);
        if (CollectionUtils.isNotEmpty(filters)) {
            List<Filter> independentFilters = this.getIndependentFilters(filters, filterIdRelations);
            for (Filter filter : independentFilters) {
                ArrayList dependentFilters = Lists.newArrayList((Object[])new Filter[]{filter});
                parts.add(this.resolve(dependentFilters, dateStringInputFormats, columnTranslation));
            }
            List<List<Filter>> dependentFilters = this.getDependentFilters(filters, filterIdRelations);
            for (List<Filter> subDependentFilters : dependentFilters) {
                parts.add(this.resolve(subDependentFilters, dateStringInputFormats, columnTranslation));
            }
        }
        return parts;
    }

    private List<List<String>> buildFilterIdRelations(List<FilterRelationDto> filterRelations) {
        return filterRelations.stream().map(this::buildRelatedFilterIds).collect(Collectors.toList());
    }

    private List<String> buildRelatedFilterIds(FilterRelationDto filterRelation) {
        return filterRelation.getRelatedFilters().stream().map(RelatedFilterDto::getId).collect(Collectors.toList());
    }

    private List<Filter> getIndependentFilters(List<Filter> filters, List<List<String>> filterIdRelations) {
        return filters.stream().filter(filter -> !this.isRelatedFilter(filter.getField(), filterIdRelations)).collect(Collectors.toList());
    }

    private boolean isRelatedFilter(String field, List<List<String>> filterIdRelations) {
        return filterIdRelations.stream().flatMap(Collection::stream).anyMatch(relatedFilterId -> StringUtils.equals((CharSequence)field, (CharSequence)relatedFilterId));
    }

    private List<List<Filter>> getDependentFilters(List<Filter> filters, List<List<String>> filterIdRelations) {
        ArrayList<List<Filter>> dependentFilters = new ArrayList<List<Filter>>();
        for (List<String> relatedFilterIds : filterIdRelations) {
            dependentFilters.add(this.filterFilters(filters, relatedFilterIds));
        }
        return dependentFilters;
    }

    private List<Filter> filterFilters(List<Filter> filters, List<String> relatedFilterIds) {
        return filters.stream().filter(filter -> relatedFilterIds.contains(filter.getField())).collect(Collectors.toList());
    }

    private String resolve(List<Filter> filters, Map<String, String> dateStringInputFormats, ColumnTranslation columnTranslation) {
        FilterType filterType = filters.get(0).getType();
        return filterType.buildQueryPart(filters, dateStringInputFormats, columnTranslation);
    }
}

