/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.resolver.recordprovider.DocumentClassResolver;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DocumentClassResolverImpl
implements DocumentClassResolver {
    private static final String TABLE_NAME_PREFIX = "pm_idx000";
    private static final String COLUMN_NAME_PREFIX = "idx000";

    @Override
    public DocumentClass resolve(String name) {
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        return documentClassService.getDocumentClass(name, new String[0]);
    }

    @Override
    public DocumentClassIndex resolveIndex(DocumentClass documentClass, String name) {
        List<DocumentClassIndex> indexes = this.resolveIndexesList(documentClass);
        if (CollectionUtils.isNotEmpty(indexes)) {
            for (DocumentClassIndex index : indexes) {
                if (!StringUtils.equals((CharSequence)index.getName(), (CharSequence)name)) continue;
                return index;
            }
        }
        return null;
    }

    @Override
    public Map<String, DocumentClassIndex> resolveIndexes(DocumentClass documentClass) {
        List<DocumentClassIndex> indexes = this.resolveIndexesList(documentClass);
        return this.convertIndexesToMap(indexes);
    }

    public List<DocumentClassIndex> resolveIndexesList(DocumentClass documentClass) {
        DocumentClassIndexFinder documentClassIndexFinder = FinderFactory.getDocumentClassIndexFinder();
        return documentClassIndexFinder.findByDocumentClass(documentClass.getId());
    }

    private Map<String, DocumentClassIndex> convertIndexesToMap(List<DocumentClassIndex> indexes) {
        HashMap<String, DocumentClassIndex> map = new HashMap<String, DocumentClassIndex>();
        for (DocumentClassIndex index : indexes) {
            map.put(index.getName(), index);
        }
        return map;
    }

    @Override
    public String resolveTableName(DocumentClass documentClass) {
        StringBuilder tableName = new StringBuilder();
        tableName.append(TABLE_NAME_PREFIX);
        tableName.append(documentClass.getId());
        return tableName.toString();
    }

    @Override
    public String resolveColumnName(DocumentClassIndex index) {
        StringBuilder columnName = new StringBuilder();
        columnName.append(COLUMN_NAME_PREFIX);
        columnName.append(index.getId());
        return columnName.toString();
    }
}

