/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.provider.record;

import com.suncode.plugin.pzmodule.api.dto.configuration.ColumnDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.GroupSumDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PanelsConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SearchCriterionDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.exception.RecordProviderException;
import com.suncode.plugin.pzmodule.api.info.AttachedInfo;
import com.suncode.plugin.pzmodule.api.info.FilterInfo;
import com.suncode.plugin.pzmodule.api.info.PagingInfo;
import com.suncode.plugin.pzmodule.api.info.SearchInfo;
import com.suncode.plugin.pzmodule.api.info.SortInfo;
import com.suncode.plugin.pzmodule.api.info.support.SubGroupsFilter;
import com.suncode.plugin.pzmodule.api.provider.record.CustomWhereClauseBuilder;
import com.suncode.plugin.pzmodule.api.record.RecordPage;
import com.suncode.plugin.pzmodule.api.result.GroupSumResult;
import com.suncode.plugin.pzmodule.api.result.SumAllResult;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.object.WhereCondition;
import com.suncode.plugin.pzmodule.provider.record.InternalRecordProvider;
import com.suncode.plugin.pzmodule.resolver.configuration.ConfigurationResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.AttachedQueryPartResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.Binding;
import com.suncode.plugin.pzmodule.resolver.recordprovider.BindingResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.ColumnTypesResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.CustomWhereClauseBuilderResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.FilterQueryPartResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.GetGroupQueryPartResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.GroupByResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.PartialAttachmentQueryPartResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.PartialAttachmentSubqueryResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.QueryResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.QueryScalarResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.RecordPageResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.RecordSumResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.SorterQueryPartResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.SubGroupsFilterQueryPartResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.SumResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.UsedQueryPartResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.WhereConditionQueryPartResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.WhereConditionResolver;
import com.suncode.plugin.pzmodule.translation.Translator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternalRecordProviderImpl
implements InternalRecordProvider {
    private static final Logger LOG = Logger.getLogger(InternalRecordProviderImpl.class);
    private static final String CONFIGURATION_ERROR_MESSAGE = "pzmodule.program.configuration.error";
    @Autowired
    private ConfigurationResolver configurationResolver;
    @Autowired
    private ColumnTypesResolver columnTypesResolver;
    @Autowired
    private WhereConditionResolver whereConditionResolver;
    @Autowired
    private CustomWhereClauseBuilderResolver customWhereClauseBuilderResolver;
    @Autowired
    private QueryScalarResolver queryScalarResolver;
    @Autowired
    private SubGroupsFilterQueryPartResolver subGroupsFilterQueryPartResolver;
    @Autowired
    private PartialAttachmentSubqueryResolver partialAttachmentSubqueryResolver;
    @Autowired
    private WhereConditionQueryPartResolver whereConditionQueryPartResolver;
    @Autowired
    private UsedQueryPartResolver usedQueryPartResolver;
    @Autowired
    private FilterQueryPartResolver filterQueryPartResolver;
    @Autowired
    private AttachedQueryPartResolver attachedQueryPartResolver;
    @Autowired
    private PartialAttachmentQueryPartResolver partialAttachmentQueryPartResolver;
    @Autowired
    private GetGroupQueryPartResolver getGroupQueryPartResolver;
    @Autowired
    private SorterQueryPartResolver sorterQueryPartResolver;
    @Autowired
    private BindingResolver bindingResolver;
    @Autowired
    private QueryResolver queryResolver;
    @Autowired
    private RecordPageResolver recordPageResolver;
    @Autowired
    private SumResolver sumResolver;
    @Autowired
    private GroupByResolver groupByResolver;
    @Autowired
    private RecordSumResolver recordSumResolver;
    @Autowired
    private Translator translator;

    @Override
    public RecordPage getPage(ConfigurationDto configuration, boolean attached, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo, SortInfo sortInfo, PagingInfo pagingInfo, String tableName, ColumnTranslation columnTranslation) throws RecordProviderException {
        List<WhereCondition> whereConditions;
        List<ColumnDto> columns = this.configurationResolver.resolveColumns(configuration, attached);
        Map<String, ColumnType> columnTypes = this.columnTypesResolver.resolve(columns);
        Map<String, String> dateStringInputFormats = this.resolveDateStringInputFormats(columns);
        List<SearchCriterionDto> searchCriteria = this.configurationResolver.resolveSearchCriteria(configuration, attached);
        if (this.shouldPreventQueryExecution(attached, searchCriteria, whereConditions = this.whereConditionResolver.resolve(searchCriteria, searchInfo.getActivityContext(), searchInfo.getExtraParameters(), columnTypes))) {
            return new RecordPage();
        }
        List<String> conditions = this.resolveConditions(configuration, tableName, columnTypes, whereConditions, attached, attachedInfo, dateStringInputFormats, searchInfo, filterInfo, columnTranslation);
        SubGroupsFilter subGroupsFilter = searchInfo.getSubGroupsFilter();
        String subGroupsFilterQueryPart = "";
        ArrayList<String> sorters = new ArrayList();
        ArrayList<String> resultColumnIds = new ArrayList<String>();
        ArrayList<String> selects = new ArrayList<String>();
        LinkedHashMap scalars = new LinkedHashMap();
        LinkedHashMap<String, String> expressions = new LinkedHashMap<String, String>();
        for (ColumnDto column : columns) {
            if (StringUtils.isBlank((CharSequence)column.getExpression())) {
                String columnId = columnTranslation.getTranslation(column.getDataIndex());
                resultColumnIds.add(columnId);
                selects.add(columnId);
                scalars.put(columnId, this.queryScalarResolver.resolve(column));
                continue;
            }
            expressions.put(column.getDataIndex(), column.getExpression());
        }
        if (BooleanUtils.isNotTrue((Boolean)searchInfo.getPreventAmount()) && this.isPartialAttachmentActive(configuration)) {
            String partialAmountSelect = this.partialAttachmentSubqueryResolver.resolvePartialAmountSelect(configuration, attached, searchInfo, tableName, columnTypes, columnTranslation);
            resultColumnIds.add("PZ_PARTIAL_AMOUNT");
            selects.add(partialAmountSelect);
            scalars.put("PZ_PARTIAL_AMOUNT", (AbstractStandardBasicType<?>)StandardBasicTypes.DOUBLE);
        }
        if (this.shouldApplySubGroupFilter(subGroupsFilter)) {
            subGroupsFilterQueryPart = this.subGroupsFilterQueryPartResolver.resolve(subGroupsFilter, tableName, conditions, configuration.getFilterRelations(), dateStringInputFormats, columnTranslation);
        }
        if (BooleanUtils.isNotTrue((Boolean)searchInfo.getPreventSort())) {
            sorters = this.sorterQueryPartResolver.resolve(sortInfo.getSorters(), columnTranslation);
        }
        Binding binding = this.bindingResolver.resolve(attached, configuration);
        String dataQuery = this.queryResolver.resolveDataQuery(selects, tableName, subGroupsFilterQueryPart, conditions, sorters);
        String countQuery = "";
        LOG.info((Object)("Zapytanie dla danych: " + dataQuery));
        if (this.shouldBuildCountQuery(configuration.getPanelsConfiguration())) {
            countQuery = this.queryResolver.resolveCountQuery(tableName, subGroupsFilterQueryPart, conditions);
            LOG.info((Object)("Zapytanie dla ilosci: " + countQuery));
        }
        return this.recordPageResolver.resolve(attached, dataQuery, countQuery, configuration, resultColumnIds, scalars, expressions, dateStringInputFormats, binding, searchInfo, pagingInfo, columnTranslation);
    }

    private Map<String, String> resolveDateStringInputFormats(List<ColumnDto> columns) {
        HashMap<String, String> dateStringInputFormats = new HashMap<String, String>();
        for (ColumnDto column : columns) {
            if (!this.isDateStringColumnType(column)) continue;
            dateStringInputFormats.put(column.getDataIndex(), column.getInputDateFormat());
        }
        return dateStringInputFormats;
    }

    private boolean isDateStringColumnType(ColumnDto column) {
        ColumnType columnType = ColumnType.getByName(column.getColumnType());
        return columnType.equals((Object)ColumnType.DATE_STRING);
    }

    private boolean shouldPreventQueryExecution(boolean attached, List<SearchCriterionDto> searchCriteria, List<WhereCondition> whereConditions) {
        return attached && this.areNotAllSearchCriteriaAvailable(searchCriteria, whereConditions);
    }

    private boolean areNotAllSearchCriteriaAvailable(List<SearchCriterionDto> searchCriteria, List<WhereCondition> whereConditions) {
        return CollectionUtils.size(searchCriteria) != CollectionUtils.size(whereConditions);
    }

    private List<String> resolveConditions(ConfigurationDto configuration, String tableName, Map<String, ColumnType> columnTypes, List<WhereCondition> whereConditions, boolean attached, AttachedInfo attachedInfo, Map<String, String> dateStringInputFormats, SearchInfo searchInfo, FilterInfo filterInfo, ColumnTranslation columnTranslation) throws RecordProviderException {
        ArrayList<String> conditions = new ArrayList<String>();
        String whereClauseClass = configuration.getSearch().getWhereClauseClass();
        if (StringUtils.isNotBlank((CharSequence)whereClauseClass)) {
            String whereClause = this.resolveCustomWhereClause(whereClauseClass, configuration, attached, searchInfo);
            if (StringUtils.isNotBlank((CharSequence)whereClause)) {
                conditions.add(this.resolveCustomWhereClause(whereClause));
            }
        } else {
            conditions.addAll(this.whereConditionQueryPartResolver.resolve(whereConditions, columnTranslation));
        }
        if (this.shouldResolveUsedCondition(configuration, attached)) {
            conditions.add(this.usedQueryPartResolver.resolve(configuration, searchInfo, tableName, columnTypes, columnTranslation));
        }
        if (this.shouldResolvePartialAttachmentCondition(configuration, attached)) {
            conditions.add(this.partialAttachmentQueryPartResolver.resolve(configuration, searchInfo, tableName, columnTypes, columnTranslation));
        }
        conditions.addAll(this.filterQueryPartResolver.resolve(filterInfo.getFilters(), configuration.getFilterRelations(), dateStringInputFormats, columnTranslation));
        conditions.addAll(this.attachedQueryPartResolver.resolve(configuration, attachedInfo.getIds(), searchInfo, tableName, columnTypes, columnTranslation));
        conditions.addAll(this.getGroupQueryPartResolver.resolve(searchInfo.getGetGroups(), columnTypes, columnTranslation));
        return conditions;
    }

    private String resolveCustomWhereClause(String whereClauseClass, ConfigurationDto configuration, boolean attached, SearchInfo searchInfo) throws RecordProviderException {
        CustomWhereClauseBuilder builder = this.customWhereClauseBuilderResolver.resolove(whereClauseClass);
        if (builder == null) {
            throw new RecordProviderException(this.buildConfigurationErrorMessage());
        }
        return builder.build(configuration, attached, searchInfo);
    }

    private String resolveCustomWhereClause(String whereClause) {
        StringBuilder condition = new StringBuilder();
        condition.append("(");
        condition.append(whereClause);
        condition.append(")");
        return condition.toString();
    }

    private boolean shouldResolveUsedCondition(ConfigurationDto configuration, boolean attached) {
        return !attached && BooleanUtils.isNotTrue((Boolean)configuration.getEnableDuplicateChoice()) && StringUtils.isBlank((CharSequence)configuration.getPartialAttachmentConfiguration().getAmountColumnId());
    }

    private boolean shouldResolvePartialAttachmentCondition(ConfigurationDto configuration, boolean attached) {
        return !attached && StringUtils.isNotBlank((CharSequence)configuration.getPartialAttachmentConfiguration().getAmountColumnId());
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR_MESSAGE);
    }

    private boolean isPartialAttachmentActive(ConfigurationDto configuration) {
        return StringUtils.isNotBlank((CharSequence)configuration.getPartialAttachmentConfiguration().getAmountColumnId());
    }

    private boolean shouldApplySubGroupFilter(SubGroupsFilter filter) {
        return StringUtils.isNotBlank((CharSequence)filter.getGroupingField()) && CollectionUtils.isNotEmpty(filter.getFilters());
    }

    private boolean shouldBuildCountQuery(PanelsConfigurationDto panelsConfiguration) {
        return BooleanUtils.isNotTrue((Boolean)panelsConfiguration.getNotAttachedPagingDisabled());
    }

    @Override
    public List<GroupSumResult> sumInGroups(ConfigurationDto configuration, boolean attached, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo, String tableName, ColumnTranslation columnTranslation) throws RecordProviderException {
        List<GroupSumDto> groupSums = this.configurationResolver.resolveGroupSums(configuration, attached);
        List<ColumnDto> columns = this.configurationResolver.resolveColumns(configuration, attached);
        Map<String, ColumnType> columnTypes = this.columnTypesResolver.resolve(columns);
        Map<String, String> dateStringInputFormats = this.resolveDateStringInputFormats(columns);
        List<SearchCriterionDto> searchCriteria = this.configurationResolver.resolveSearchCriteria(configuration, attached);
        List<WhereCondition> whereConditions = this.whereConditionResolver.resolve(searchCriteria, searchInfo.getActivityContext(), searchInfo.getExtraParameters(), columnTypes);
        List<String> conditions = this.resolveConditions(configuration, tableName, columnTypes, whereConditions, attached, attachedInfo, dateStringInputFormats, searchInfo, filterInfo, columnTranslation);
        SubGroupsFilter subGroupsFilter = searchInfo.getSubGroupsFilter();
        String subGroupsFilterQueryPart = "";
        LinkedHashMap scalars = new LinkedHashMap();
        ArrayList<String> sumSelects = new ArrayList<String>();
        ArrayList<String> resultColumnIds = new ArrayList<String>();
        for (GroupSumDto groupSum : groupSums) {
            String sumAlias = this.sumResolver.resolveAlias(groupSum.getColumnId(), columnTranslation);
            resultColumnIds.add(columnTranslation.getTranslation(groupSum.getColumnId()));
            sumSelects.add(this.sumResolver.resolveSelect(configuration, searchInfo, groupSum.getColumnId(), sumAlias, tableName, columnTypes, columnTranslation));
            scalars.put(sumAlias, (AbstractStandardBasicType<?>)StandardBasicTypes.DOUBLE);
        }
        if (this.shouldApplySubGroupFilter(subGroupsFilter)) {
            subGroupsFilterQueryPart = this.subGroupsFilterQueryPartResolver.resolve(subGroupsFilter, tableName, conditions, configuration.getFilterRelations(), dateStringInputFormats, columnTranslation);
        }
        String groupBy = this.groupByResolver.resolvePartialAttachmentGroupSumGroupBy(configuration, groupSums);
        String sumsQuery = this.queryResolver.resolveSumsQuery(sumSelects, tableName, subGroupsFilterQueryPart, conditions, groupBy);
        LOG.info((Object)("Zapytanie dla sum w grupach: " + sumsQuery));
        return this.recordSumResolver.resolveSumInGroups(sumsQuery, configuration, resultColumnIds, scalars, searchInfo, columnTranslation);
    }

    @Override
    public SumAllResult sumAll(ConfigurationDto configuration, boolean attached, String columnId, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo, String tableName, ColumnTranslation columnTranslation) throws RecordProviderException {
        List<ColumnDto> columns = this.configurationResolver.resolveColumns(configuration, attached);
        Map<String, ColumnType> columnTypes = this.columnTypesResolver.resolve(columns);
        Map<String, String> dateStringInputFormats = this.resolveDateStringInputFormats(columns);
        List<SearchCriterionDto> searchCriteria = this.configurationResolver.resolveSearchCriteria(configuration, attached);
        List<WhereCondition> whereConditions = this.whereConditionResolver.resolve(searchCriteria, searchInfo.getActivityContext(), searchInfo.getExtraParameters(), columnTypes);
        List<String> conditions = this.resolveConditions(configuration, tableName, columnTypes, whereConditions, attached, attachedInfo, dateStringInputFormats, searchInfo, filterInfo, columnTranslation);
        LinkedHashMap scalars = new LinkedHashMap();
        String sumAlias = this.sumResolver.resolveAlias(columnId, columnTranslation);
        String sumSelect = this.sumResolver.resolveSelect(configuration, searchInfo, columnId, sumAlias, tableName, columnTypes, columnTranslation);
        String resultColumnId = columnTranslation.getTranslation(columnId);
        scalars.put(sumAlias, (AbstractStandardBasicType<?>)StandardBasicTypes.DOUBLE);
        String sumQuery = this.queryResolver.resolveSumAllQuery(sumSelect, tableName, conditions);
        LOG.info((Object)("Zapytanie dla sumy: " + sumQuery));
        return this.recordSumResolver.resolveSumAll(sumQuery, configuration, resultColumnId, scalars, searchInfo, columnTranslation);
    }
}

