/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.executor.save.record;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionParameterDto;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.evaluator.SaveActionParameterEvaluator;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.exception.SetProcessContextException;
import com.suncode.plugin.pzmodule.executor.save.record.SaveActionExecutor;
import com.suncode.plugin.pzmodule.service.shark.SharkService;
import com.suncode.plugin.pzmodule.translation.Translator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.InvalidData;
import org.enhydra.shark.api.client.wfmodel.UpdateNotAllowed;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="saveVariablesSaveActionExecutor")
public class SaveVariablesSaveActionExecutorImpl
implements SaveActionExecutor {
    private static final Logger LOG = Logger.getLogger(SaveVariablesSaveActionExecutorImpl.class);
    private static final String CONFIGURATION_ERROR_MESSAGE = "pzmodule.program.configuration.error";
    private static final String SAVE_ERROR_MESSAGE = "pzmodule.program.save.error";
    @Autowired
    private SaveActionParameterEvaluator saveActionParameterEvaluator;
    @Autowired
    private SharkService sharkService;
    @Autowired
    private Translator translator;

    @Override
    public void execute(SharkTransaction sharkTransaction, Session session, ConfigurationDto configuration, SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords) throws SaveActionExecutorException {
        String processId = saveInfo.getProcessId();
        String activityId = saveInfo.getActivityId();
        if (CollectionUtils.isNotEmpty(saveAction.getParameters())) {
            try {
                Map<String, Object> processContext = this.getProcessContext(sharkTransaction, processId);
                Map<String, Object> activityContext = this.getActivityContext(sharkTransaction, processId, activityId);
                String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
                String primaryKeyVariableId = this.getPrimaryKeyVariableId(saveAction, primaryKeyName);
                for (SaveActionParameterDto saveActionParameter : saveAction.getParameters()) {
                    this.execute(saveActionParameter, saveInfo, processContext, activityContext, attachedRecords, primaryKeyName, primaryKeyVariableId, BooleanUtils.isTrue((Boolean)saveAction.getUpdate()));
                }
                this.setProcessContext(sharkTransaction, processId, processContext);
                this.setActivityContext(sharkTransaction, processId, activityId, activityContext);
            }
            catch (SaveActionExecutorException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOG.error((Object)exception.getMessage(), (Throwable)exception);
                throw new SaveActionExecutorException(this.buildSaveErrorMessage());
            }
        }
    }

    private String getPrimaryKeyVariableId(SaveActionDto saveAction, String primaryKeyName) throws SaveActionExecutorException {
        if (BooleanUtils.isTrue((Boolean)saveAction.getUpdate())) {
            return saveAction.getParameters().stream().filter(parameter -> StringUtils.equals((CharSequence)parameter.getFromValue(), (CharSequence)primaryKeyName)).findFirst().map(SaveActionParameterDto::getToValue).orElseThrow(() -> new SaveActionExecutorException("Brak zapisu identyfikatora rekord\u00f3w"));
        }
        return "";
    }

    private void execute(SaveActionParameterDto saveActionParameter, SaveInfo saveInfo, Map<String, Object> processContext, Map<String, Object> activityContext, List<Record> attachedRecords, String primaryKeyName, String primaryKeyVariableId, boolean update) throws SaveActionExecutorException {
        String to = saveActionParameter.getToValue();
        if (StringUtils.isBlank((CharSequence)to)) {
            LOG.error((Object)"Brak wartosci docelowej dla parametru akcji zapisu");
            throw new SaveActionExecutorException(this.buildConfigurationErrorMessage());
        }
        Record emptyRecord = new Record();
        String value = this.saveActionParameterEvaluator.evaluate(saveActionParameter, saveInfo, emptyRecord, attachedRecords, activityContext, primaryKeyName, primaryKeyVariableId, update);
        processContext = this.putValueToContext(processContext, saveActionParameter.getToValue(), value);
        activityContext = this.putValueToContext(activityContext, saveActionParameter.getToValue(), value);
    }

    private Map<String, Object> getProcessContext(SharkTransaction sharkTransaction, String processId) throws BaseException, ConnectFailed, NotConnected {
        return this.sharkService.getProcessContext(sharkTransaction, processId);
    }

    private Map<String, Object> getActivityContext(SharkTransaction sharkTransaction, String processId, String activityId) throws BaseException, ConnectFailed, NotConnected {
        return this.sharkService.getActivityContext(sharkTransaction, processId, activityId);
    }

    private Map<String, Object> putValueToContext(Map<String, Object> context, String id, String value) {
        return this.sharkService.putValueToContext(context, id, value);
    }

    private void setProcessContext(SharkTransaction sharkTransaction, String processId, Map<String, Object> context) throws BaseException, ConnectFailed, NotConnected, SetProcessContextException {
        this.sharkService.setProcessContext(sharkTransaction, processId, context);
    }

    private void setActivityContext(SharkTransaction sharkTransaction, String processId, String activityId, Map<String, Object> context) throws BaseException, InvalidData, UpdateNotAllowed, ConnectFailed, NotConnected {
        this.sharkService.setActivityContext(sharkTransaction, processId, activityId, context);
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR_MESSAGE);
    }

    private String buildSaveErrorMessage() {
        return this.translator.translateMessage(SAVE_ERROR_MESSAGE);
    }
}

