/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.executor.save.record;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.executor.save.record.SaveActionExecutor;
import com.suncode.plugin.pzmodule.service.partialattachment.PartialAttachmentService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.api.SharkTransaction;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="partialAttachmentSaveActionExecutor")
public class PartialAttachmentSaveActionExecutorImpl
implements SaveActionExecutor {
    private static final String ZERO = "0";
    @Autowired
    private PartialAttachmentService partialAttachmentService;

    @Override
    public void execute(SharkTransaction sharkTransaction, Session session, ConfigurationDto configuration, SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords) throws SaveActionExecutorException {
        List<Record> detachedRecords;
        String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
        String amountColumnId = configuration.getPartialAttachmentConfiguration().getAmountColumnId();
        ArrayList<String> attachedPrimaryKeyValues = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(attachedRecords)) {
            for (Record record : attachedRecords) {
                String primaryKeyValue = record.getValue(primaryKeyName);
                String stringAmount = (String)StringUtils.defaultIfBlank((CharSequence)record.getValue(amountColumnId), (CharSequence)ZERO);
                Double amount = Double.valueOf(stringAmount);
                attachedPrimaryKeyValues.add(primaryKeyValue);
                this.partialAttachmentService.attach(configuration, saveInfo, primaryKeyValue, amount);
            }
        }
        if (CollectionUtils.isNotEmpty(detachedRecords = this.getDetachedRecords(saveInfo, attachedPrimaryKeyValues, primaryKeyName))) {
            for (Record record : detachedRecords) {
                String primaryKeyValue = record.getValue(primaryKeyName);
                this.partialAttachmentService.detach(configuration, saveInfo, primaryKeyValue);
            }
        }
    }

    private List<Record> getDetachedRecords(SaveInfo saveInfo, List<String> attachedPrimaryKeyValues, String primaryKeyName) {
        ArrayList<Record> records = new ArrayList<Record>();
        if (CollectionUtils.isNotEmpty(saveInfo.getInitiallyAttachedRecords())) {
            for (Record record : saveInfo.getInitiallyAttachedRecords()) {
                String primaryKeyValue = record.getValue(primaryKeyName);
                if (attachedPrimaryKeyValues.contains(primaryKeyValue)) continue;
                records.add(record);
            }
        }
        return records;
    }
}

