/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.dao.settings;

import com.suncode.plugin.pzmodule.dao.settings.SettingsDao;
import com.suncode.plugin.pzmodule.model.settings.Settings;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class SettingsDaoImpl
extends HibernateEditableDao<Settings, Long>
implements SettingsDao {
    @Override
    public List<Settings> getUserSettings(Boolean attached, String ownerId, String configurationId) {
        DetachedCriteria criteria = this.getUserSettingsCriteria(attached, ownerId, configurationId);
        return this.findByCriteria(criteria);
    }

    @Override
    public Settings getUserSettingsByName(Boolean attached, String ownerId, String configurationId, String name) {
        DetachedCriteria criteria = this.getUserSettingsCriteria(attached, ownerId, configurationId);
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name).ignoreCase());
        return (Settings)this.findOne(criteria);
    }

    @Override
    public Settings getDefaultUserSettings(Boolean attached, String ownerId, String configurationId) {
        DetachedCriteria criteria = this.getUserSettingsCriteria(attached, ownerId, configurationId);
        criteria.add((Criterion)Restrictions.eq((String)"isDefault", (Object)true));
        return (Settings)this.findOne(criteria);
    }

    @Override
    public List<Settings> getConfigurationSettings(String configurationId) {
        DetachedCriteria criteria = this.getConfigurationSettingsCriteria(configurationId);
        return this.findByCriteria(criteria);
    }

    private DetachedCriteria getUserSettingsCriteria(Boolean attached, String ownerId, String configurationId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Settings.class);
        criteria.add((Criterion)Restrictions.eq((String)"attached", (Object)attached));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"ownerId", (Object)ownerId), (Criterion)Restrictions.eq((String)"shared", (Object)true)));
        criteria.add((Criterion)Restrictions.eq((String)"configurationId", (Object)configurationId));
        return criteria;
    }

    private DetachedCriteria getConfigurationSettingsCriteria(String configurationId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Settings.class);
        criteria.add((Criterion)Restrictions.eq((String)"configurationId", (Object)configurationId));
        return criteria;
    }
}

