/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.api.enumeration;

import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.api.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SaveActionParameterOperation {
    CURRENT("current"){

        @Override
        public String calculate(String from, String to, Record record, List<Record> attachedRecords, List<Record> detachedRecords, Map<String, Object> activityContext, String valueJoiner, String primaryKeyName, String primaryKeyVariableId, boolean accumulate, boolean update) {
            Assert.hasText((String)from, (String)"Value must not be null, empty, or blank");
            return record.getValue(from);
        }
    }
    ,
    VALUE("value"){

        @Override
        public String calculate(String from, String to, Record record, List<Record> attachedRecords, List<Record> detachedRecords, Map<String, Object> activityContext, String valueJoiner, String primaryKeyName, String primaryKeyVariableId, boolean accumulate, boolean update) {
            Assert.hasText((String)from, (String)"Value must not be null, empty, or blank");
            ArrayList<String> values = new ArrayList<String>();
            if (2.hasRecords(attachedRecords)) {
                ArrayList<String> currentKeys = new ArrayList<String>();
                if (update) {
                    String currentKey = (String)activityContext.get(primaryKeyVariableId);
                    List<String> currentKeysTmp = Arrays.asList(StringUtils.split((String)currentKey, (String)valueJoiner, (int)-1));
                    String currentTo = (String)activityContext.get(to);
                    List<String> currentTosTmp = Arrays.asList(StringUtils.split((String)currentTo, (String)valueJoiner, (int)-1));
                    List indexesToSkip = detachedRecords.stream().map(detachedRecord -> detachedRecord.getValue(primaryKeyName)).map(primaryKeyValue -> currentKeysTmp.indexOf(primaryKeyValue)).collect(Collectors.toList());
                    for (int i = 0; i < currentKeysTmp.size(); ++i) {
                        if (indexesToSkip.contains(i)) continue;
                        currentKeys.add(currentKeysTmp.get(i));
                        if (CollectionUtils.size(currentTosTmp) > i) {
                            values.add(currentTosTmp.get(i));
                            continue;
                        }
                        values.add("");
                    }
                }
                for (Record attachedRecord : attachedRecords) {
                    String currentValue = attachedRecord.getValue(from);
                    if (update) {
                        String primaryKeyValue2 = attachedRecord.getValue(primaryKeyName);
                        int index = currentKeys.indexOf(primaryKeyValue2);
                        if (index != -1 && CollectionUtils.size(values) > index) {
                            values.set(index, currentValue);
                            continue;
                        }
                        values.add(currentValue);
                        continue;
                    }
                    values.add(currentValue);
                }
            }
            return StringUtils.join(values, (String)valueJoiner);
        }
    }
    ,
    FIXED("fixed"){

        @Override
        public String calculate(String from, String to, Record record, List<Record> attachedRecords, List<Record> detachedRecords, Map<String, Object> activityContext, String valueJoiner, String primaryKeyName, String primaryKeyVariableId, boolean accumulate, boolean update) {
            return this.accumulateResult(from, valueJoiner, accumulate);
        }
    }
    ,
    SUM_INT("sumint"){

        @Override
        public String calculate(String from, String to, Record record, List<Record> attachedRecords, List<Record> detachedRecords, Map<String, Object> activityContext, String valueJoiner, String primaryKeyName, String primaryKeyVariableId, boolean accumulate, boolean update) {
            Assert.hasText((String)from, (String)"Value must not be null, empty, or blank");
            Double result = this.sum(from, attachedRecords);
            result = MathUtils.round(result, INTEGER_ACCURACY);
            String stringResult = result.toString();
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    SUM_FLOAT("sumfloat"){

        @Override
        public String calculate(String from, String to, Record record, List<Record> attachedRecords, List<Record> detachedRecords, Map<String, Object> activityContext, String valueJoiner, String primaryKeyName, String primaryKeyVariableId, boolean accumulate, boolean update) {
            Assert.hasText((String)from, (String)"Value must not be null, empty, or blank");
            Double result = this.sum(from, attachedRecords);
            String stringResult = result.toString();
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    MULTIPLY_INT("multiplyint"){

        @Override
        public String calculate(String from, String to, Record record, List<Record> attachedRecords, List<Record> detachedRecords, Map<String, Object> activityContext, String valueJoiner, String primaryKeyName, String primaryKeyVariableId, boolean accumulate, boolean update) {
            Assert.hasText((String)from, (String)"Value must not be null, empty, or blank");
            Double result = this.multiply(from, attachedRecords);
            result = MathUtils.round(result, INTEGER_ACCURACY);
            String stringResult = result.toString();
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    MULTIPLY_FLOAT("multiplyfloat"){

        @Override
        public String calculate(String from, String to, Record record, List<Record> attachedRecords, List<Record> detachedRecords, Map<String, Object> activityContext, String valueJoiner, String primaryKeyName, String primaryKeyVariableId, boolean accumulate, boolean update) {
            Assert.hasText((String)from, (String)"Value must not be null, empty, or blank");
            Double result = this.multiply(from, attachedRecords);
            String stringResult = result.toString();
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    AVERAGE("avg"){

        @Override
        public String calculate(String from, String to, Record record, List<Record> attachedRecords, List<Record> detachedRecords, Map<String, Object> activityContext, String valueJoiner, String primaryKeyName, String primaryKeyVariableId, boolean accumulate, boolean update) {
            Assert.hasText((String)from, (String)"Value must not be null, empty, or blank");
            Double result = this.sum(from, attachedRecords);
            double total = attachedRecords.size();
            result = MathUtils.divide(result, total);
            String stringResult = result.toString();
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    AMOUNT("amount"){

        @Override
        public String calculate(String from, String to, Record record, List<Record> attachedRecords, List<Record> detachedRecords, Map<String, Object> activityContext, String valueJoiner, String primaryKeyName, String primaryKeyVariableId, boolean accumulate, boolean update) {
            String stringResult = String.valueOf(attachedRecords.size());
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    VARIABLE("variable"){

        @Override
        public String calculate(String from, String to, Record record, List<Record> attachedRecords, List<Record> detachedRecords, Map<String, Object> activityContext, String valueJoiner, String primaryKeyName, String primaryKeyVariableId, boolean accumulate, boolean update) {
            Assert.hasText((String)from, (String)"Value must not be null, empty, or blank");
            String stringResult = "";
            Object result = activityContext.get(from);
            if (result != null) {
                stringResult = result.toString();
            }
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    UNKNOWN(""){

        @Override
        public String calculate(String from, String to, Record record, List<Record> attachedRecords, List<Record> detachedRecords, Map<String, Object> activityContext, String valueJoiner, String primaryKeyName, String primaryKeyVariableId, boolean accumulate, boolean update) {
            return null;
        }
    };

    private String name;
    private static final int INTEGER_ACCURACY;

    private SaveActionParameterOperation(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SaveActionParameterOperation getByName(String name) {
        for (SaveActionParameterOperation saveActionParameterOperation : SaveActionParameterOperation.values()) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)saveActionParameterOperation.getName())) continue;
            return saveActionParameterOperation;
        }
        return UNKNOWN;
    }

    public abstract String calculate(String var1, String var2, Record var3, List<Record> var4, List<Record> var5, Map<String, Object> var6, String var7, String var8, String var9, boolean var10, boolean var11);

    public Double sum(String from, List<Record> attachedRecords) {
        Double result = 0.0;
        if (SaveActionParameterOperation.hasRecords(attachedRecords)) {
            for (Record record : attachedRecords) {
                String tempValue = record.getValue(from);
                if (StringUtils.isBlank((CharSequence)tempValue)) {
                    tempValue = "0.0";
                }
                result = MathUtils.add(result, Double.valueOf(tempValue));
            }
        }
        return result;
    }

    public Double multiply(String from, List<Record> attachedRecords) {
        Double result = 1.0;
        if (SaveActionParameterOperation.hasRecords(attachedRecords)) {
            for (Record record : attachedRecords) {
                String tempValue = record.getValue(from);
                if (StringUtils.isBlank((CharSequence)tempValue)) {
                    tempValue = "1.0";
                }
                result = MathUtils.multiply(result, Double.valueOf(tempValue));
            }
        }
        return result;
    }

    public String accumulateResult(String stringResult, String valueJoiner, boolean accumulate) {
        if (accumulate) {
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < values.size(); ++i) {
                values.add(stringResult);
            }
            return StringUtils.join(values, (String)valueJoiner);
        }
        return stringResult;
    }

    public static boolean hasRecords(List<Record> records) {
        return records != null && !records.isEmpty();
    }

    static {
        INTEGER_ACCURACY = 0;
    }
}

