( function( Ext ) {
	var messages = Suncode.context( 'pzmodule' ).messages;
	
    Ext.define( 'Suncode.pzmodule.view.table.SettingsTable', {
        extend: 'Ext.grid.Panel',
        alias: 'widget.settingstable',
        selModel: {
            model: 'SINGLE'
        },
        border: 0,
        columnLines: true,
        viewConfig: {
            enableTextSelection: true,
            emptyText: messages( 'pzmodule.nosettings' ),
            markDirty: false
        },
        columns: [ {
        	dataIndex: 'name',
        	text: messages( 'pzmodule.name' ),
        	flex: 1,
        	renderer: function( value, metaData, record, rowIndex, colIndex, store, view ) {
        		metaData.tdCls += 'pzmodule-text-wrap ';
        		
        		return value;
        	}
        }, {
          dataIndex: 'isDefault',
          text: messages( 'pzmodule.default' ),
          width: 80,
          align: 'center',
          renderer: function( value, metaData, record, rowIndex, colIndex, store, view ) {
            if ( value ) {
              return '<div class="dvnt-icon-check-symbol dvnt-green-icon" />';
            } else {
              return '<div class="dvnt-icon-x-symbol dvnt-red-icon" />';
            }
          }
        }, {
          dataIndex: 'shared',
          text: messages( 'pzmodule.shared' ),
          width: 80,
          align: 'center',
          renderer: function( value, metaData, record, rowIndex, colIndex, store, view ) {
            if ( value ) {
              return '<div class="dvnt-icon-check-symbol dvnt-green-icon" />';
            } else {
              return '<div class="dvnt-icon-x-symbol dvnt-red-icon" />';
            }
          }
        } ],
        initComponent: function() {
        	var table = this.table;
        	var configuration = table.configuration;
        	
            this.store = Ext.create( 'Ext.data.Store', {
                autoLoad: true,
                autoDestroy: true,
                fields: [ {
                	name: 'id',
                	type: 'int'
                }, {
                	name: 'name',
                	type: 'string'
                }, {
                	name: 'isDefault',
                	type: 'boolean'
                }, {
                  name: 'shared',
                  type: 'boolean'
                }, {
                  name: 'ownerId',
                  type: 'string'
                } ],
                sorters: [ {
                	property: 'name',
                	direction: 'ASC'
                } ],
                proxy: {
                    type: 'rest',
                    api: {
                        read: 'api/settings/read',
                        destroy: 'api/settings/delete'
                    },
                    reader: {
                        type: 'json',
                        root: 'data'
                    },
                    extraParams: {
                        attached: table.isAttached(),
                        configurationId: configuration.configurationId
                    },
                    timeout: 900000,
                    noCache: false,
                    pageParam: undefined,
                    startParam: undefined,
                    limitParam: undefined
                }
            } );
            
            this.callParent();
        }
    } );
}( this.Ext4 ) );