(function (Ext) {
  Ext.define('Suncode.pzmodule.view.column.RecordColumn', {
    extend: 'Ext.grid.column.Column',
    alias: 'widget.recordcolumn',
    renderer: function (value, metaData, record, rowIndex, colIndex, store,
        view) {
      var column = metaData.column;
      var formattedValue = column.formatColumnValue(value);

      if (column.editable) {
        metaData.tdCls += 'pzmodule-editable-cell ';
      }

      if (column.wrapText) {
        metaData.tdCls += 'pzmodule-text-wrap ';
      }

      if (column.cellTooltip) {
        metaData.tdAttr += 'data-qtip="' + formattedValue + '";';
      }

      if (!Ext.isEmpty(column.fontSize)) {
        metaData.style += 'font-size: ' + column.fontSize + 'px;';
      }

      return formattedValue;
    },
    formatColumnValue: function (value) {
      if (this.isDateColumn && Ext.isDate(value)) {
        return this.formatDateColumnValue(value);
      } else if (this.isFloatColumn && (Ext.isNumeric(value) || Ext.isEmpty(
          value))) {
        return this.formatFloatColumnValue(value);
      } else {
        return Ext.util.Format.htmlEncode(value);
      }
    },
    formatDateColumnValue: function (value) {
      value = value.format(this.dateFormat);

      return value;
    },
    formatFloatColumnValue: function (value) {
      var rounder = this.getRounder();
      value = Ext.isEmpty(value) ? '0' : value;
      value = String(value).replace(this.decimalSeparator, '.');
      value = Math.round(parseFloat(value) * rounder ) / rounder;
      value = Ext.Number.toFixed(value, this.decimalPrecision);
      value = String(value).replace('.', this.decimalSeparator);
      var splittedValue = value.split(this.decimalSeparator, -1);
      var integerPart = splittedValue[0];
      var decimalPart = splittedValue[1];
      var digits = new Array();
      var pos = 1;

      for (var i = integerPart.length; i > 0; i--) {
        var digit = integerPart.charAt(i - 1);
        digits.push(digit);

        if (pos % 3 == 0 && i > 1) {
          digits.push(' ');
        }

        pos++;
      }

      digits.reverse();
      value = digits.join('');

      if (!Ext.isEmpty(decimalPart)) {
        value += this.decimalSeparator;
        value += decimalPart;
      }

      return value;
    },
    getRounder: function() {
      var rounder = '1';
      for (var i = 0; i < this.decimalPrecision; i++) {
        rounder += '0';
      }

      return parseInt(rounder);
    },
    initComponent: function () {
      this.callParent(arguments);
    }
  });
}(this.Ext4));