( function( Ext ) {
	var messages = Suncode.context( 'pzmodule' ).messages;
	
    Ext.define( 'Suncode.pzmodule.controller.button.SettingsWindowButtonController', {
        extend: 'Ext.app.Controller',
        init: function() {
            this.control( {
            	  'settingswindow button[itemId=loadSettingsButton]': {
                	click: this.loadSettings
                },
                'settingswindow button[itemId=setAsDefaultButton]': {
                	click: this.setAsDefault
                },
            	  'settingswindow button[itemId=deleteSettingsButton]': {
                	click: this.deleteSettings
                },
                'settingswindow button[itemId=cancelButton]': {
                	click: this.closeWindow
                }
            } );
        },
        loadSettings: function( button, e, eOpts ) {
        	var win = button.up( 'window' );
        	var table = win.down( 'settingstable ' );
            var selected = table.getSelectionModel().getSelection();

            if ( !Ext.isEmpty( selected ) ) {
            	var selectedSettings = selected.first();
            	
            	Ext.Ajax.request( {
                    url: 'api/settings/read/' + selectedSettings.get( 'id' ),
                    method: 'GET',
                    timeout: 900000,
                    scope: this,
                    success: function( response, options ) {
                    	var result = Ext.JSON.decode( response.responseText );
                    	
                    	if ( result.success ) {
                    		this.doLoadSettings( win.table, result.data );
                        	win.close();
                    	} else {
                    		this.showSettingsOperationError( result.message, win );
                    	}
                    },
                    failure: function( response, options ) {
                    	this.showSettingsOperationError( messages( 'pzmodule.settingsloaderror' ), win );
                    }
                } );
            } else {
                this.showChooseSettingsWarning( win );
            }
        },
        doLoadSettings: function( table, settings ) {
        	var store = table.getStore();
          var groupersSettings = settings.groupingSettings.groupersSettings;
          var sortersSettings = settings.sortingSettings.sortersSettings;

          if ( !Ext.isEmpty( groupersSettings ) ) {
            store.group( groupersSettings );
          } else {
            store.clearGrouping();
          }

          if ( !Ext.isEmpty( sortersSettings ) ) {
            store.sort( sortersSettings );
          }
        },
        showSettingsOperationError: function( errorMessage, win ) {
          if ( Ext.isString( errorMessage ) ) {
            var msgBox = Ext.Msg.show( {
              title: messages( 'pzmodule.error' ),
              msg: errorMessage,
              buttons: Ext.Msg.OK,
              icon: 'dvnt-icon-x-circle dvnt-red-icon'
            } );
            this.showMsgBoxInCenter( msgBox, win );
          }
        },
        setAsDefault: function( button, e, eOpts ) {
        	  var win = button.up( 'window' );
        	  var table = win.down( 'settingstable ' );
            var selected = table.getSelectionModel().getSelection();

            if ( !Ext.isEmpty( selected ) ) {
            	var selectedSettings = selected.first();
              var ownerId = selectedSettings.get( 'ownerId' );

              if ( ownerId !== Suncode.context( 'pzmodule' ).userId ) {
                this.showNotSettingOwnerWarning( win );
                return;
              }

            	var recordTable = win.table;
            	var configuration = recordTable.configuration;
            	
            	Ext.Ajax.request( {
                    url: 'api/settings/setasdefault/' + selectedSettings.get( 'id' ),
                    method: 'GET',
                    params: {
                    	attached: recordTable.isAttached(),
                    	configurationId: configuration.configurationId
                    },
                    timeout: 900000,
                    scope: this,
                    success: function( response, options ) {
                    	var result = Ext.JSON.decode( response.responseText );
                    	
                    	if ( result.success ) {
                    		var store = table.getStore();
                        	var defaultSettingsIndex = store.find( 'isDefault', true );
                        	
                        	if ( defaultSettingsIndex != -1 ) {
                        		var defaultSettings = store.getAt( defaultSettingsIndex );
                        		defaultSettings.set( 'isDefault', false );
                        		defaultSettings.commit();
                        	}
                        	
                        	selectedSettings.set( 'isDefault', true );
                        	selectedSettings.commit();
                        	store.sync();
                    	} else {
                    		this.showSettingsOperationError( result.message, win );
                    	}
                    },
                    failure: function( response, options ) {
                    	this.showSettingsOperationError( messages( 'pzmodule.setasdefaulterror' ), win );
                    }
                } );
            } else {
                this.showChooseSettingsWarning( win );
            }
        },
        deleteSettings: function( button, e, eOpts ) {
        	var win = button.up( 'window' );
        	var table = win.down( 'settingstable ' );
            var selected = table.getSelectionModel().getSelection();

            if ( !Ext.isEmpty( selected ) ) {
                var store = table.getStore();
                store.remove( selected );
                store.sync( {
                	scope: this,
                    success: function ( batch, options ) {
                    	table.getView().refresh();
                    },
                    failure: function ( batch, options ) {
                        store.rejectChanges();
                        this.showSettingsOperationError( messages( 'pzmodule.deletionerror' ), win );
                    }
                } );
            } else {
                this.showChooseSettingsWarning( win );
            }
        },
        closeWindow: function( button, e, eOpts ) {
        	button.up( 'window' ).close();
        },
        showChooseSettingsWarning: function( win ) {
        	var msgBox = Ext.Msg.show( {
                title: messages( 'pzmodule.warning' ),
                msg: messages( 'pzmodule.choosesettings' ),
                buttons: Ext.Msg.OK,
                icon: 'dvnt-icon-exclamation-triangle dvnt-red-icon'
            } );
        	this.showMsgBoxInCenter( msgBox, win );
        },
        showNotSettingOwnerWarning: function( win ) {
          var msgBox = Ext.Msg.show( {
            title: messages( 'pzmodule.warning' ),
            msg: messages( 'pzmodule.notsettingsowner' ),
            buttons: Ext.Msg.OK,
            icon: 'dvnt-icon-exclamation-triangle dvnt-red-icon'
          } );
          this.showMsgBoxInCenter( msgBox, win );
        },
        showMsgBoxInCenter: function( msgBox, win ) {
        	var x = win.getX() + win.getWidth() / 2 - msgBox.getWidth() / 2;
        	var y = win.getY() + win.getHeight() / 2 - msgBox.getHeight() / 2;
        	msgBox.setXY( [ x, y ] );
        }
    } );
}( this.Ext4 ) );