( function( Ext ) {
	var messages = Suncode.context( 'pzmodule' ).messages;
	
    Ext.define( 'Suncode.pzmodule.controller.button.SaveSettingsWindowButtonController', {
        extend: 'Ext.app.Controller',
        init: function() {
            this.control( {
                'savesettingswindow button[itemId=saveSettingsButton]': {
                	click: this.saveSettings
                },
                'savesettingswindow button[itemId=cancelButton]': {
                	click: this.closeWindow
                }
            } );
        },
        saveSettings: function( button, e, eOpts ) {
        	  var win = button.up( 'window' );
            var form = win.down( 'form' ).getForm();

            if ( form.isValid() ) {
            	var table = win.table;
            	var configuration = table.configuration;
            	var store = table.getStore();
            	var groupingSettings = {
            		groupersSettings: store.groupers.items
            	};
              var sortingSettings = {
                sortersSettings: store.sorters.items
              };
            	
                form.submit( {
                    url: Suncode.context( 'pzmodule' ).pluginContextPath + '/api/settings/create',
                    params: {
                    	attached: table.isAttached(),
                    	configurationId: configuration.configurationId,
                    	groupingSettings: Ext.JSON.encode( groupingSettings ),
                      sortingSettings: Ext.JSON.encode( sortingSettings )
                    },
                    timeout: 120,
                    scope: this,
                    success: function( form, action ) {
                    	win.close();
                    },
                    failure: function( form, action ) {
                        var errorMessage = !Ext.isEmpty( action.result ) ? action.result.message : '';
                        errorMessage = !Ext.isEmpty( errorMessage ) ? errorMessage : messages( 'pzmodule.savesettingserror' );

                        if ( Ext.isString( errorMessage ) ) {
                          var msgBox = Ext.Msg.show( {
                            title: messages( 'pzmodule.error' ),
                            msg: errorMessage,
                            buttons: Ext.Msg.OK,
                            icon: 'dvnt-icon-x-circle dvnt-red-icon'
                          } );
                          table.showWindowInCenter( msgBox );
                        }
                    }
                } );
            }
        },
        closeWindow: function( button, e, eOpts ) {
        	button.up( 'window' ).close();
        }
    } );
}( this.Ext4 ) );