( function( Ext ) {
	var messages = Suncode.context( 'pzmodule' ).messages;
	
    Ext.define( 'Suncode.pzmodule.controller.button.AttachmentWindowButtonController', {
        extend: 'Ext.app.Controller',
        init: function() {
            this.control( {
            	'attachmentwindow button[itemId=confirmAttachmentButton]': {
                	click: this.confirmAttachment
                },
            	'attachmentwindow button[itemId=deleteRecordsButton]': {
                	click: this.deleteRecords
                },
                'attachmentwindow button[itemId=cancelButton]': {
                	click: this.closeWindow
                }
            } );
        },
        confirmAttachment: function( button, e, eOpts ) {
        	var win = button.up( 'window' );
        	var table = win.down( 'attachmenttable ' );
        	var records = table.getStore().getRange();
        	
        	if ( !Ext.isEmpty( records ) ) {
        		win.close();
        		var recordTable = table.table;
        		recordTable.attach( records );
        	} else {
        		this.showNoRecordsWarning( win );
        	}
        },
        deleteRecords: function( button, e, eOpts ) {
        	var win = button.up( 'window' );
        	var table = win.down( 'attachmenttable ' );
        	var selModel = table.getSelectionModel();
        	var selections = selModel.getSelection();
        	
        	if ( !Ext.isEmpty( selections ) ) {
        		var store = table.getStore();
            	store.suspendAutoSync();
            	store.remove( selections );
            	store.resumeAutoSync();
            	var recordTable = table.table;
            	recordTable.deselectRecords( selections );
        	} else {
        		this.showChooseRecordsWarning( win );
        	}
        },
        closeWindow: function( button, e, eOpts ) {
        	button.up( 'window' ).close();
        },
        showNoRecordsWarning: function( win ) {
        	this.showWarning( messages( 'pzmodule.norecords' ), win );
        },
        showChooseRecordsWarning: function( win ) {
        	this.showWarning( messages( 'pzmodule.chooserecords' ), win );
        },
        showWarning: function( msg, win ) {
        	var msgBox = Ext.Msg.show( {
                title: messages( 'pzmodule.warning' ),
                msg: msg,
                buttons: Ext.Msg.OK,
				icon: 'dvnt-icon-exclamation-triangle dvnt-red-icon'
            } );
        	this.showMsgBoxInCenter( msgBox, win );
        },
        showMsgBoxInCenter: function( msgBox, win ) {
        	var x = win.getX() + win.getWidth() / 2 - msgBox.getWidth() / 2;
        	var y = win.getY() + win.getHeight() / 2 - msgBox.getHeight() / 2;
        	msgBox.setXY( [ x, y ] );
        }
    } );
}( this.Ext4 ) );