( function( Ext ) {
    var messages = Suncode.context( 'pzmodule' ).messages;

    Ext.define( 'Suncode.pzmodule.controller.button.ConfigurationTableButtonController', {
        extend: 'Ext.app.Controller',
        init: function() {
        	this.eventbus.unlisten( this.id );
            this.control( {
                'configurationtable button[itemId=addConfigurationButton]': {
                    click: this.addConfiguration
                },
                'configurationtable button[itemId=editConfigurationButton]': {
                    click: this.editConfiguration
                },
                'configurationtable button[itemId=deleteConfigurationButton]': {
                    click: this.deleteConfiguration
                },
                'configurationtable button[itemId=downloadConfigurationButton]': {
                    click: this.downloadConfiguration
                },
                'configurationtable button[itemId=importAttachedButton]': {
                    click: this.importAttached
                }
            } );
        },
        addConfiguration: function( button, e, eOpts ) {
        	var table = button.up( 'configurationtable' );
        	
            var win = Ext.create( 'Suncode.pzmodule.view.window.ManageConfigurationWindow', {
            	title: messages( 'pzmodule.addconfiguration' ),
            	table: table
            } );
            win.show();
        },
        editConfiguration: function( button, e, eOpts ) {
        	var table = button.up( 'configurationtable' );
            var selected = table.getSelectionModel().getSelection();

            if ( !Ext.isEmpty( selected ) ) {
            	var configuration = selected[0];
            	var win = Ext.create( 'Suncode.pzmodule.view.window.ManageConfigurationWindow', {
            		title: messages( 'pzmodule.editconfiguration' ),
                	table: table,
                	idOfConfiguration: configuration.get( 'id' )
                } );
                win.show();
            } else {
            	this.showChooseConfigurationWarning();
            }
        },
        deleteConfiguration: function( button, e, eOpts ) {
            var table = button.up( 'configurationtable' );
            var selected = table.getSelectionModel().getSelection();

            if ( !Ext.isEmpty( selected ) ) {
                var store = table.getStore();
                store.remove( selected );
                store.sync( {
                	scope: this,
                    success: function ( batch, options ) {
                    	table.getView().refresh();
                    },
                    failure: function ( batch, options ) {
                        store.rejectChanges();
                        Ext.Msg.show( {
                            title: messages( 'pzmodule.error' ),
                            msg: messages( 'pzmodule.deletionerror' ),
                            buttons: Ext.Msg.OK,
                            icon: 'dvnt-icon-x-circle dvnt-red-icon'
                        } );
                    }
                } );
            } else {
                this.showChooseConfigurationWarning();
            }
        },
        downloadConfiguration: function( button, e, eOpts ) {
        	var table = button.up( 'configurationtable' );
            var selected = table.getSelectionModel().getSelection();

            if ( !Ext.isEmpty( selected ) ) {
            	var configuration = selected[0];
            	var idOfConfiguration = configuration.get( 'id' );
            	var configurationId = configuration.get( 'configurationId' );
            	var url = Suncode.context( 'pzmodule' ).pluginContextPath
            		+ '/api/administration/configuration/download/' + idOfConfiguration;
            	var form = jQuery( '<form/>', { action: url, method: 'post' } );
            	form.append( jQuery( '<input>', { type: 'text', name: 'configurationId', value: configurationId } ) );
                
                var iframe = jQuery( '#download-frame' );
                iframe.empty();
                iframe.append( form );
                
                form.submit();
            } else {
                this.showChooseConfigurationWarning();
            }
        },
        importAttached: function( button, e, eOpts ) {
        	Ext.create( 'Suncode.pzmodule.view.window.ImportAttachedWindow' ).show();
        },
        showChooseConfigurationWarning: function() {
        	Ext.Msg.show( {
                title: messages( 'pzmodule.warning' ),
                msg: messages( 'pzmodule.chooseconfiguration' ),
                buttons: Ext.Msg.OK,
                icon: 'dvnt-icon-exclamation-triangle dvnt-red-icon'
            } );
        }
    } );
}( this.Ext4 ) );