(function (Ext) {
  runPzModuleAdministration = function () {
    var renderTo = 'pzmodule-administration-div';
    var configurationTableId = 'pzmodule-configuration-table';
    Ext.destroy(Ext.getCmp(configurationTableId));

    Ext.Loader.setConfig({
      enabled: true,
      disableCaching: false
    });

    Ext.application({
      name: 'Suncode.pzmodule',
      appFolder: Suncode.context('pzmodule').resources
          + '/scripts/administration',
      requires: ['Suncode.pzmodule.view.table.ConfigurationTable'],
      controllers: ['table.ConfigurationTableController',
        'button.ConfigurationTableButtonController',
        'button.ManageConfigurationWindowButtonController',
        'window.ManageConfigurationWindowController',
        'button.ImportAttachedWindowButtonController'],
      launch: function () {
        Ext.QuickTips.init();
        this.initOverrides();
        this.setCookieProvider();
        this.buildView();
      },
      initOverrides: function () {
        this.overrideRowNumbererRenderer();
      },
      overrideRowNumbererRenderer: function () {
        Ext.override(Ext.grid.RowNumberer, {
          renderer: function (value, metaData, record, rowIdx, colIdx, store) {
            var rowspan = this.rowspan;
            if (rowspan) {
              metaData.tdAttr = 'rowspan="' + rowspan + '"';
            }

            metaData.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';

            return store.indexOf(record) + 1;
          }
        });
      },
      setCookieProvider: function () {
        var currentTime = new Date().getTime();
        var expirationTime = 1000 * 60 * 60 * 24 * 7;

        Ext.state.Manager.setProvider(new Ext.state.CookieProvider({
          expires: new Date(currentTime + expirationTime)
        }));
      },
      buildView: function () {
        Ext.create('Suncode.pzmodule.view.table.ConfigurationTable', {
          id: configurationTableId,
          renderTo: renderTo,
          width: Ext.get(renderTo).getWidth(),
          height: 500
        });
      }
    });
  };
})(Ext4);