/**
 * Run PZ module.
 */
PW.FormActions.create( 'run-pz-module', {
    buttonInit: function( button ) {
        this.button = button;
    },
    dtButtonInit: function( dtButton ) {
    	this.button = dtButton;
    },
    enable: function() {
    	this.button.on( 'click', this.runPzModule, this );
    },
    disable: function() {
    	this.button.off( 'click', this.runPzModule, this );
    },
    runPzModule: function() {
        if ( this.get( "saveForm" ) ) {
            FormService.save( {
                scope: this,
                success: function () {
                    this.openPzModuleWindow();
                },
                failure: function() {
                    MessageService.showFailure();
                }
            } )
        } else {
            this.openPzModuleWindow();
        }
    },
    openPzModuleWindow: function () {
        var href = this.buildPzModuleHref();
        window.open( href, '_self' );
    },
    buildPzModuleHref: function() {
    	var href = this.getUrl();
    	href += '/plugin/com.suncode.plugin-pzmodule/?configurationId=';
    	href += this.get( 'configurationId' );
    	href += '&processId=';
    	href += processId;
    	href += '&activityId=';
    	href += activityId;

    	var extraParamsNames = this.get( 'extraParamsNames' );
    	var extraParamsValues = this.get( 'extraParamsValues' );

    	if ( !Ext.isEmpty( extraParamsNames ) && !Ext.isEmpty( extraParamsValues ) ) {
    		Ext.each( extraParamsNames, function( name, index, names ) {
    			var value = extraParamsValues[index];

    			if ( Ext.isDefined( value ) ) {
    				if ( !Ext.isEmpty( name ) ) {
    					href += '&';
        				href += name;
        				href += '=';
        				href += value;
    				}
    			} else {
    				return false;
    			}
    		} );
    	}

    	return href;
    },
    getUrl: function() {
    	var url = [ document.location.protocol, '//', document.location.host, document.location.pathname ].join( '' );
        var lastSymbol = url.lastIndexOf( '/' );

        if ( lastSymbol != 0 && lastSymbol != -1 ) {
            url = url.substring( 0, lastSymbol );
        }

        return url;
    }
} );